package org.openqa.selenium.devtools.v140.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Fired when 103 Early Hints headers is received in addition to the common response.
 * Not every responseReceived event will have an responseReceivedEarlyHints fired.
 * Only one responseReceivedEarlyHints may be fired for eached responseReceived event.
 */
@org.openqa.selenium.Beta()
public class ResponseReceivedEarlyHints {

    private final org.openqa.selenium.devtools.v140.network.model.RequestId requestId;

    private final org.openqa.selenium.devtools.v140.network.model.Headers headers;

    public ResponseReceivedEarlyHints(org.openqa.selenium.devtools.v140.network.model.RequestId requestId, org.openqa.selenium.devtools.v140.network.model.Headers headers) {
        this.requestId = java.util.Objects.requireNonNull(requestId, "requestId is required");
        this.headers = java.util.Objects.requireNonNull(headers, "headers is required");
    }

    /**
     * Request identifier. Used to match this information to another responseReceived event.
     */
    public org.openqa.selenium.devtools.v140.network.model.RequestId getRequestId() {
        return requestId;
    }

    /**
     * Raw response headers as they were received over the wire.
     * Duplicate headers in the response are represented as a single key with their values
     * concatentated using `\n` as the separator.
     * See also `headersText` that contains verbatim text for HTTP/1.*.
     */
    public org.openqa.selenium.devtools.v140.network.model.Headers getHeaders() {
        return headers;
    }

    private static ResponseReceivedEarlyHints fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v140.network.model.RequestId requestId = null;
        org.openqa.selenium.devtools.v140.network.model.Headers headers = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "requestId":
                    requestId = input.read(org.openqa.selenium.devtools.v140.network.model.RequestId.class);
                    break;
                case "headers":
                    headers = input.read(org.openqa.selenium.devtools.v140.network.model.Headers.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new ResponseReceivedEarlyHints(requestId, headers);
    }
}
