package org.openqa.selenium.devtools.v141.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public class SRIMessageSignatureIssueDetails {

    private final org.openqa.selenium.devtools.v141.audits.model.SRIMessageSignatureError error;

    private final java.lang.String signatureBase;

    private final java.util.List<java.lang.String> integrityAssertions;

    private final org.openqa.selenium.devtools.v141.audits.model.AffectedRequest request;

    public SRIMessageSignatureIssueDetails(org.openqa.selenium.devtools.v141.audits.model.SRIMessageSignatureError error, java.lang.String signatureBase, java.util.List<java.lang.String> integrityAssertions, org.openqa.selenium.devtools.v141.audits.model.AffectedRequest request) {
        this.error = java.util.Objects.requireNonNull(error, "error is required");
        this.signatureBase = java.util.Objects.requireNonNull(signatureBase, "signatureBase is required");
        this.integrityAssertions = java.util.Objects.requireNonNull(integrityAssertions, "integrityAssertions is required");
        this.request = java.util.Objects.requireNonNull(request, "request is required");
    }

    public org.openqa.selenium.devtools.v141.audits.model.SRIMessageSignatureError getError() {
        return error;
    }

    public java.lang.String getSignatureBase() {
        return signatureBase;
    }

    public java.util.List<java.lang.String> getIntegrityAssertions() {
        return integrityAssertions;
    }

    public org.openqa.selenium.devtools.v141.audits.model.AffectedRequest getRequest() {
        return request;
    }

    private static SRIMessageSignatureIssueDetails fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v141.audits.model.SRIMessageSignatureError error = null;
        java.lang.String signatureBase = null;
        java.util.List<java.lang.String> integrityAssertions = null;
        org.openqa.selenium.devtools.v141.audits.model.AffectedRequest request = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "error":
                    error = input.read(org.openqa.selenium.devtools.v141.audits.model.SRIMessageSignatureError.class);
                    break;
                case "signatureBase":
                    signatureBase = input.nextString();
                    break;
                case "integrityAssertions":
                    integrityAssertions = input.readArray(java.lang.String.class);
                    break;
                case "request":
                    request = input.read(org.openqa.selenium.devtools.v141.audits.model.AffectedRequest.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new SRIMessageSignatureIssueDetails(error, signatureBase, integrityAssertions, request);
    }
}
