package org.openqa.selenium.devtools.v142.css.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * CSS function conditional block representation.
 */
public class CSSFunctionConditionNode {

    private final java.util.Optional<org.openqa.selenium.devtools.v142.css.model.CSSMedia> media;

    private final java.util.Optional<org.openqa.selenium.devtools.v142.css.model.CSSContainerQuery> containerQueries;

    private final java.util.Optional<org.openqa.selenium.devtools.v142.css.model.CSSSupports> supports;

    private final java.util.List<org.openqa.selenium.devtools.v142.css.model.CSSFunctionNode> children;

    private final java.lang.String conditionText;

    public CSSFunctionConditionNode(java.util.Optional<org.openqa.selenium.devtools.v142.css.model.CSSMedia> media, java.util.Optional<org.openqa.selenium.devtools.v142.css.model.CSSContainerQuery> containerQueries, java.util.Optional<org.openqa.selenium.devtools.v142.css.model.CSSSupports> supports, java.util.List<org.openqa.selenium.devtools.v142.css.model.CSSFunctionNode> children, java.lang.String conditionText) {
        this.media = media;
        this.containerQueries = containerQueries;
        this.supports = supports;
        this.children = java.util.Objects.requireNonNull(children, "children is required");
        this.conditionText = java.util.Objects.requireNonNull(conditionText, "conditionText is required");
    }

    /**
     * Media query for this conditional block. Only one type of condition should be set.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v142.css.model.CSSMedia> getMedia() {
        return media;
    }

    /**
     * Container query for this conditional block. Only one type of condition should be set.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v142.css.model.CSSContainerQuery> getContainerQueries() {
        return containerQueries;
    }

    /**
     * @supports CSS at-rule condition. Only one type of condition should be set.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v142.css.model.CSSSupports> getSupports() {
        return supports;
    }

    /**
     * Block body.
     */
    public java.util.List<org.openqa.selenium.devtools.v142.css.model.CSSFunctionNode> getChildren() {
        return children;
    }

    /**
     * The condition text.
     */
    public java.lang.String getConditionText() {
        return conditionText;
    }

    private static CSSFunctionConditionNode fromJson(JsonInput input) {
        java.util.Optional<org.openqa.selenium.devtools.v142.css.model.CSSMedia> media = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v142.css.model.CSSContainerQuery> containerQueries = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v142.css.model.CSSSupports> supports = java.util.Optional.empty();
        java.util.List<org.openqa.selenium.devtools.v142.css.model.CSSFunctionNode> children = null;
        java.lang.String conditionText = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "media":
                    media = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v142.css.model.CSSMedia.class));
                    break;
                case "containerQueries":
                    containerQueries = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v142.css.model.CSSContainerQuery.class));
                    break;
                case "supports":
                    supports = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v142.css.model.CSSSupports.class));
                    break;
                case "children":
                    children = input.readArray(org.openqa.selenium.devtools.v142.css.model.CSSFunctionNode.class);
                    break;
                case "conditionText":
                    conditionText = input.nextString();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new CSSFunctionConditionNode(media, containerQueries, supports, children, conditionText);
    }
}
