package org.openqa.selenium.devtools.v142.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Fired once when parsing the .wbn file has failed.
 */
@org.openqa.selenium.Beta()
public class SubresourceWebBundleMetadataError {

    private final org.openqa.selenium.devtools.v142.network.model.RequestId requestId;

    private final java.lang.String errorMessage;

    public SubresourceWebBundleMetadataError(org.openqa.selenium.devtools.v142.network.model.RequestId requestId, java.lang.String errorMessage) {
        this.requestId = java.util.Objects.requireNonNull(requestId, "requestId is required");
        this.errorMessage = java.util.Objects.requireNonNull(errorMessage, "errorMessage is required");
    }

    /**
     * Request identifier. Used to match this information to another event.
     */
    public org.openqa.selenium.devtools.v142.network.model.RequestId getRequestId() {
        return requestId;
    }

    /**
     * Error message
     */
    public java.lang.String getErrorMessage() {
        return errorMessage;
    }

    private static SubresourceWebBundleMetadataError fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v142.network.model.RequestId requestId = null;
        java.lang.String errorMessage = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "requestId":
                    requestId = input.read(org.openqa.selenium.devtools.v142.network.model.RequestId.class);
                    break;
                case "errorMessage":
                    errorMessage = input.nextString();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new SubresourceWebBundleMetadataError(requestId, errorMessage);
    }
}
