/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v84;

import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import org.openqa.selenium.JavascriptException;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.DevTools;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.events.ConsoleEvent;
import org.openqa.selenium.devtools.idealized.Events;
import org.openqa.selenium.devtools.idealized.runtime.model.RemoteObject;
import org.openqa.selenium.devtools.v84.runtime.Runtime;
import org.openqa.selenium.devtools.v84.runtime.model.ConsoleAPICalled;
import org.openqa.selenium.devtools.v84.runtime.model.ExceptionDetails;
import org.openqa.selenium.devtools.v84.runtime.model.ExceptionThrown;
import org.openqa.selenium.devtools.v84.runtime.model.StackTrace;

public class V84Events
extends Events<ConsoleAPICalled, ExceptionThrown> {
    public V84Events(DevTools devtools) {
        super(devtools);
    }

    protected Command<Void> enableRuntime() {
        return Runtime.enable();
    }

    protected Command<Void> disableRuntime() {
        return Runtime.disable();
    }

    protected Event<ConsoleAPICalled> consoleEvent() {
        return Runtime.consoleAPICalled();
    }

    protected Event<ExceptionThrown> exceptionThrownEvent() {
        return Runtime.exceptionThrown();
    }

    protected ConsoleEvent toConsoleEvent(ConsoleAPICalled event) {
        long ts = new BigDecimal(event.getTimestamp().toJson()).longValue();
        List modifiedArgs = (List)event.getArgs().stream().map(obj -> new RemoteObject(obj.getType().toString(), obj.getValue().orElse(null))).map(obj -> obj).collect(ImmutableList.toImmutableList());
        return new ConsoleEvent(event.getType().toString(), Instant.ofEpochMilli(ts), new Object[]{modifiedArgs});
    }

    protected JavascriptException toJsException(ExceptionThrown event) {
        ExceptionDetails details = event.getExceptionDetails();
        Optional<StackTrace> maybeTrace = details.getStackTrace();
        JavascriptException exception = new JavascriptException(event.getExceptionDetails().getText());
        if (!maybeTrace.isPresent()) {
            StackTraceElement element = new StackTraceElement("unknown", "unknown", details.getUrl().orElse("unknown"), details.getLineNumber());
            exception.setStackTrace(new StackTraceElement[]{element});
            return exception;
        }
        StackTrace trace = maybeTrace.get();
        exception.setStackTrace((StackTraceElement[])trace.getCallFrames().stream().map(frame -> new StackTraceElement("", frame.getFunctionName(), frame.getUrl(), frame.getLineNumber())).toArray(StackTraceElement[]::new));
        return exception;
    }
}

