/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v84.storage;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v84.browser.model.BrowserContextID;
import org.openqa.selenium.devtools.v84.network.model.Cookie;
import org.openqa.selenium.devtools.v84.network.model.CookieParam;
import org.openqa.selenium.devtools.v84.storage.model.CacheStorageContentUpdated;
import org.openqa.selenium.devtools.v84.storage.model.IndexedDBContentUpdated;
import org.openqa.selenium.devtools.v84.storage.model.UsageForType;
import org.openqa.selenium.json.JsonInput;

@Beta
public class Storage {
    public static Command<Void> clearDataForOrigin(String origin, String storageTypes) {
        Objects.requireNonNull(origin, "origin is required");
        Objects.requireNonNull(storageTypes, "storageTypes is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"origin", (Object)origin);
        params.put((Object)"storageTypes", (Object)storageTypes);
        return new Command("Storage.clearDataForOrigin", (Map)params.build());
    }

    public static Command<List<Cookie>> getCookies(Optional<BrowserContextID> browserContextId) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        browserContextId.ifPresent(p -> params.put((Object)"browserContextId", p));
        return new Command("Storage.getCookies", (Map)params.build(), ConverterFunctions.map((String)"cookies", (Type)new TypeToken<List<Cookie>>(){}.getType()));
    }

    public static Command<Void> setCookies(List<CookieParam> cookies, Optional<BrowserContextID> browserContextId) {
        Objects.requireNonNull(cookies, "cookies is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"cookies", cookies);
        browserContextId.ifPresent(p -> params.put((Object)"browserContextId", p));
        return new Command("Storage.setCookies", (Map)params.build());
    }

    public static Command<Void> clearCookies(Optional<BrowserContextID> browserContextId) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        browserContextId.ifPresent(p -> params.put((Object)"browserContextId", p));
        return new Command("Storage.clearCookies", (Map)params.build());
    }

    public static Command<GetUsageAndQuotaResponse> getUsageAndQuota(String origin) {
        Objects.requireNonNull(origin, "origin is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"origin", (Object)origin);
        return new Command("Storage.getUsageAndQuota", (Map)params.build(), input -> (GetUsageAndQuotaResponse)input.read(GetUsageAndQuotaResponse.class));
    }

    public static Command<Void> trackCacheStorageForOrigin(String origin) {
        Objects.requireNonNull(origin, "origin is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"origin", (Object)origin);
        return new Command("Storage.trackCacheStorageForOrigin", (Map)params.build());
    }

    public static Command<Void> trackIndexedDBForOrigin(String origin) {
        Objects.requireNonNull(origin, "origin is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"origin", (Object)origin);
        return new Command("Storage.trackIndexedDBForOrigin", (Map)params.build());
    }

    public static Command<Void> untrackCacheStorageForOrigin(String origin) {
        Objects.requireNonNull(origin, "origin is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"origin", (Object)origin);
        return new Command("Storage.untrackCacheStorageForOrigin", (Map)params.build());
    }

    public static Command<Void> untrackIndexedDBForOrigin(String origin) {
        Objects.requireNonNull(origin, "origin is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"origin", (Object)origin);
        return new Command("Storage.untrackIndexedDBForOrigin", (Map)params.build());
    }

    public static Event<CacheStorageContentUpdated> cacheStorageContentUpdated() {
        return new Event("Storage.cacheStorageContentUpdated", input -> (CacheStorageContentUpdated)input.read(CacheStorageContentUpdated.class));
    }

    public static Event<String> cacheStorageListUpdated() {
        return new Event("Storage.cacheStorageListUpdated", ConverterFunctions.map((String)"origin", String.class));
    }

    public static Event<IndexedDBContentUpdated> indexedDBContentUpdated() {
        return new Event("Storage.indexedDBContentUpdated", input -> (IndexedDBContentUpdated)input.read(IndexedDBContentUpdated.class));
    }

    public static Event<String> indexedDBListUpdated() {
        return new Event("Storage.indexedDBListUpdated", ConverterFunctions.map((String)"origin", String.class));
    }

    public static class GetUsageAndQuotaResponse {
        private final Number usage;
        private final Number quota;
        private final List<UsageForType> usageBreakdown;

        public GetUsageAndQuotaResponse(Number usage, Number quota, List<UsageForType> usageBreakdown) {
            this.usage = Objects.requireNonNull(usage, "usage is required");
            this.quota = Objects.requireNonNull(quota, "quota is required");
            this.usageBreakdown = Objects.requireNonNull(usageBreakdown, "usageBreakdown is required");
        }

        public Number getUsage() {
            return this.usage;
        }

        public Number getQuota() {
            return this.quota;
        }

        public List<UsageForType> getUsageBreakdown() {
            return this.usageBreakdown;
        }

        private static GetUsageAndQuotaResponse fromJson(JsonInput input) {
            Number usage = 0;
            Number quota = 0;
            List usageBreakdown = null;
            input.beginObject();
            block10: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "usage": {
                        usage = input.nextNumber();
                        continue block10;
                    }
                    case "quota": {
                        quota = input.nextNumber();
                        continue block10;
                    }
                    case "usageBreakdown": {
                        usageBreakdown = (List)input.read(new TypeToken<List<UsageForType>>(){}.getType());
                        continue block10;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetUsageAndQuotaResponse(usage, quota, usageBreakdown);
        }
    }
}

