/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v86.network.model;

import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v86.network.model.CrossOriginEmbedderPolicyStatus;
import org.openqa.selenium.devtools.v86.network.model.CrossOriginOpenerPolicyStatus;
import org.openqa.selenium.json.JsonInput;

@Beta
public class SecurityIsolationStatus {
    private final CrossOriginOpenerPolicyStatus coop;
    private final CrossOriginEmbedderPolicyStatus coep;

    public SecurityIsolationStatus(CrossOriginOpenerPolicyStatus coop, CrossOriginEmbedderPolicyStatus coep) {
        this.coop = Objects.requireNonNull(coop, "coop is required");
        this.coep = Objects.requireNonNull(coep, "coep is required");
    }

    public CrossOriginOpenerPolicyStatus getCoop() {
        return this.coop;
    }

    public CrossOriginEmbedderPolicyStatus getCoep() {
        return this.coep;
    }

    private static SecurityIsolationStatus fromJson(JsonInput input) {
        CrossOriginOpenerPolicyStatus coop = null;
        CrossOriginEmbedderPolicyStatus coep = null;
        input.beginObject();
        block8: while (input.hasNext()) {
            switch (input.nextName()) {
                case "coop": {
                    coop = (CrossOriginOpenerPolicyStatus)input.read(CrossOriginOpenerPolicyStatus.class);
                    continue block8;
                }
                case "coep": {
                    coep = (CrossOriginEmbedderPolicyStatus)input.read(CrossOriginEmbedderPolicyStatus.class);
                    continue block8;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new SecurityIsolationStatus(coop, coep);
    }
}

