/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v87.network.model;

import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v87.network.model.CertificateTransparencyCompliance;
import org.openqa.selenium.devtools.v87.network.model.SignedCertificateTimestamp;
import org.openqa.selenium.devtools.v87.network.model.TimeSinceEpoch;
import org.openqa.selenium.devtools.v87.security.model.CertificateId;
import org.openqa.selenium.json.JsonInput;

public class SecurityDetails {
    private final String protocol;
    private final String keyExchange;
    private final Optional<String> keyExchangeGroup;
    private final String cipher;
    private final Optional<String> mac;
    private final CertificateId certificateId;
    private final String subjectName;
    private final List<String> sanList;
    private final String issuer;
    private final TimeSinceEpoch validFrom;
    private final TimeSinceEpoch validTo;
    private final List<SignedCertificateTimestamp> signedCertificateTimestampList;
    private final CertificateTransparencyCompliance certificateTransparencyCompliance;

    public SecurityDetails(String protocol, String keyExchange, Optional<String> keyExchangeGroup, String cipher, Optional<String> mac, CertificateId certificateId, String subjectName, List<String> sanList, String issuer, TimeSinceEpoch validFrom, TimeSinceEpoch validTo, List<SignedCertificateTimestamp> signedCertificateTimestampList, CertificateTransparencyCompliance certificateTransparencyCompliance) {
        this.protocol = Objects.requireNonNull(protocol, "protocol is required");
        this.keyExchange = Objects.requireNonNull(keyExchange, "keyExchange is required");
        this.keyExchangeGroup = keyExchangeGroup;
        this.cipher = Objects.requireNonNull(cipher, "cipher is required");
        this.mac = mac;
        this.certificateId = Objects.requireNonNull(certificateId, "certificateId is required");
        this.subjectName = Objects.requireNonNull(subjectName, "subjectName is required");
        this.sanList = Objects.requireNonNull(sanList, "sanList is required");
        this.issuer = Objects.requireNonNull(issuer, "issuer is required");
        this.validFrom = Objects.requireNonNull(validFrom, "validFrom is required");
        this.validTo = Objects.requireNonNull(validTo, "validTo is required");
        this.signedCertificateTimestampList = Objects.requireNonNull(signedCertificateTimestampList, "signedCertificateTimestampList is required");
        this.certificateTransparencyCompliance = Objects.requireNonNull(certificateTransparencyCompliance, "certificateTransparencyCompliance is required");
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getKeyExchange() {
        return this.keyExchange;
    }

    public Optional<String> getKeyExchangeGroup() {
        return this.keyExchangeGroup;
    }

    public String getCipher() {
        return this.cipher;
    }

    public Optional<String> getMac() {
        return this.mac;
    }

    public CertificateId getCertificateId() {
        return this.certificateId;
    }

    public String getSubjectName() {
        return this.subjectName;
    }

    public List<String> getSanList() {
        return this.sanList;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public TimeSinceEpoch getValidFrom() {
        return this.validFrom;
    }

    public TimeSinceEpoch getValidTo() {
        return this.validTo;
    }

    public List<SignedCertificateTimestamp> getSignedCertificateTimestampList() {
        return this.signedCertificateTimestampList;
    }

    public CertificateTransparencyCompliance getCertificateTransparencyCompliance() {
        return this.certificateTransparencyCompliance;
    }

    private static SecurityDetails fromJson(JsonInput input) {
        String protocol = null;
        String keyExchange = null;
        Optional<String> keyExchangeGroup = Optional.empty();
        String cipher = null;
        Optional<String> mac = Optional.empty();
        CertificateId certificateId = null;
        String subjectName = null;
        List sanList = null;
        String issuer = null;
        TimeSinceEpoch validFrom = null;
        TimeSinceEpoch validTo = null;
        List signedCertificateTimestampList = null;
        CertificateTransparencyCompliance certificateTransparencyCompliance = null;
        input.beginObject();
        block30: while (input.hasNext()) {
            switch (input.nextName()) {
                case "protocol": {
                    protocol = input.nextString();
                    continue block30;
                }
                case "keyExchange": {
                    keyExchange = input.nextString();
                    continue block30;
                }
                case "keyExchangeGroup": {
                    keyExchangeGroup = Optional.ofNullable(input.nextString());
                    continue block30;
                }
                case "cipher": {
                    cipher = input.nextString();
                    continue block30;
                }
                case "mac": {
                    mac = Optional.ofNullable(input.nextString());
                    continue block30;
                }
                case "certificateId": {
                    certificateId = (CertificateId)input.read(CertificateId.class);
                    continue block30;
                }
                case "subjectName": {
                    subjectName = input.nextString();
                    continue block30;
                }
                case "sanList": {
                    sanList = (List)input.read(new TypeToken<List<String>>(){}.getType());
                    continue block30;
                }
                case "issuer": {
                    issuer = input.nextString();
                    continue block30;
                }
                case "validFrom": {
                    validFrom = (TimeSinceEpoch)input.read(TimeSinceEpoch.class);
                    continue block30;
                }
                case "validTo": {
                    validTo = (TimeSinceEpoch)input.read(TimeSinceEpoch.class);
                    continue block30;
                }
                case "signedCertificateTimestampList": {
                    signedCertificateTimestampList = (List)input.read(new TypeToken<List<SignedCertificateTimestamp>>(){}.getType());
                    continue block30;
                }
                case "certificateTransparencyCompliance": {
                    certificateTransparencyCompliance = (CertificateTransparencyCompliance)((Object)input.read(CertificateTransparencyCompliance.class));
                    continue block30;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new SecurityDetails(protocol, keyExchange, keyExchangeGroup, cipher, mac, certificateId, subjectName, sanList, issuer, validFrom, validTo, signedCertificateTimestampList, certificateTransparencyCompliance);
    }
}

