/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v87.browser.model;

import java.util.Arrays;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

@Beta
public enum PermissionType {
    ACCESSIBILITYEVENTS("accessibilityEvents"),
    AUDIOCAPTURE("audioCapture"),
    BACKGROUNDSYNC("backgroundSync"),
    BACKGROUNDFETCH("backgroundFetch"),
    CLIPBOARDREADWRITE("clipboardReadWrite"),
    CLIPBOARDSANITIZEDWRITE("clipboardSanitizedWrite"),
    DURABLESTORAGE("durableStorage"),
    FLASH("flash"),
    GEOLOCATION("geolocation"),
    MIDI("midi"),
    MIDISYSEX("midiSysex"),
    NFC("nfc"),
    NOTIFICATIONS("notifications"),
    PAYMENTHANDLER("paymentHandler"),
    PERIODICBACKGROUNDSYNC("periodicBackgroundSync"),
    PROTECTEDMEDIAIDENTIFIER("protectedMediaIdentifier"),
    SENSORS("sensors"),
    VIDEOCAPTURE("videoCapture"),
    IDLEDETECTION("idleDetection"),
    WAKELOCKSCREEN("wakeLockScreen"),
    WAKELOCKSYSTEM("wakeLockSystem");

    private String value;

    private PermissionType(String value) {
        this.value = value;
    }

    public static PermissionType fromString(String s) {
        return Arrays.stream(PermissionType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within PermissionType "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static PermissionType fromJson(JsonInput input) {
        return PermissionType.fromString(input.nextString());
    }
}

