/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v87.browser.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@Beta
public class PermissionDescriptor {
    private final String name;
    private final Optional<Boolean> sysex;
    private final Optional<Boolean> userVisibleOnly;
    private final Optional<Boolean> allowWithoutSanitization;

    public PermissionDescriptor(String name, Optional<Boolean> sysex, Optional<Boolean> userVisibleOnly, Optional<Boolean> allowWithoutSanitization) {
        this.name = Objects.requireNonNull(name, "name is required");
        this.sysex = sysex;
        this.userVisibleOnly = userVisibleOnly;
        this.allowWithoutSanitization = allowWithoutSanitization;
    }

    public String getName() {
        return this.name;
    }

    public Optional<Boolean> getSysex() {
        return this.sysex;
    }

    public Optional<Boolean> getUserVisibleOnly() {
        return this.userVisibleOnly;
    }

    public Optional<Boolean> getAllowWithoutSanitization() {
        return this.allowWithoutSanitization;
    }

    private static PermissionDescriptor fromJson(JsonInput input) {
        String name = null;
        Optional<Boolean> sysex = Optional.empty();
        Optional<Boolean> userVisibleOnly = Optional.empty();
        Optional<Boolean> allowWithoutSanitization = Optional.empty();
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "name": {
                    name = input.nextString();
                    continue block12;
                }
                case "sysex": {
                    sysex = Optional.ofNullable(input.nextBoolean());
                    continue block12;
                }
                case "userVisibleOnly": {
                    userVisibleOnly = Optional.ofNullable(input.nextBoolean());
                    continue block12;
                }
                case "allowWithoutSanitization": {
                    allowWithoutSanitization = Optional.ofNullable(input.nextBoolean());
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new PermissionDescriptor(name, sysex, userVisibleOnly, allowWithoutSanitization);
    }
}

