/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v88.network.model;

import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v88.network.model.BlockedCookieWithReason;
import org.openqa.selenium.devtools.v88.network.model.Headers;
import org.openqa.selenium.devtools.v88.network.model.RequestId;
import org.openqa.selenium.json.JsonInput;

@Beta
public class RequestWillBeSentExtraInfo {
    private final RequestId requestId;
    private final List<BlockedCookieWithReason> associatedCookies;
    private final Headers headers;

    public RequestWillBeSentExtraInfo(RequestId requestId, List<BlockedCookieWithReason> associatedCookies, Headers headers) {
        this.requestId = Objects.requireNonNull(requestId, "requestId is required");
        this.associatedCookies = Objects.requireNonNull(associatedCookies, "associatedCookies is required");
        this.headers = Objects.requireNonNull(headers, "headers is required");
    }

    public RequestId getRequestId() {
        return this.requestId;
    }

    public List<BlockedCookieWithReason> getAssociatedCookies() {
        return this.associatedCookies;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    private static RequestWillBeSentExtraInfo fromJson(JsonInput input) {
        RequestId requestId = null;
        List associatedCookies = null;
        Headers headers = null;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "requestId": {
                    requestId = (RequestId)input.read(RequestId.class);
                    continue block10;
                }
                case "associatedCookies": {
                    associatedCookies = (List)input.read(new TypeToken<List<BlockedCookieWithReason>>(){}.getType());
                    continue block10;
                }
                case "headers": {
                    headers = (Headers)((Object)input.read(Headers.class));
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new RequestWillBeSentExtraInfo(requestId, associatedCookies, headers);
    }
}

