/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v89.emulation;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v89.dom.model.RGBA;
import org.openqa.selenium.devtools.v89.emulation.model.DisabledImageType;
import org.openqa.selenium.devtools.v89.emulation.model.DisplayFeature;
import org.openqa.selenium.devtools.v89.emulation.model.MediaFeature;
import org.openqa.selenium.devtools.v89.emulation.model.ScreenOrientation;
import org.openqa.selenium.devtools.v89.emulation.model.UserAgentMetadata;
import org.openqa.selenium.devtools.v89.emulation.model.VirtualTimePolicy;
import org.openqa.selenium.devtools.v89.network.model.TimeSinceEpoch;
import org.openqa.selenium.devtools.v89.page.model.Viewport;
import org.openqa.selenium.json.JsonInput;

public class Emulation {
    public static Command<Boolean> canEmulate() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Emulation.canEmulate", (Map)params.build(), ConverterFunctions.map((String)"result", Boolean.class));
    }

    public static Command<Void> clearDeviceMetricsOverride() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Emulation.clearDeviceMetricsOverride", (Map)params.build());
    }

    public static Command<Void> clearGeolocationOverride() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Emulation.clearGeolocationOverride", (Map)params.build());
    }

    @Beta
    public static Command<Void> resetPageScaleFactor() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Emulation.resetPageScaleFactor", (Map)params.build());
    }

    @Beta
    public static Command<Void> setFocusEmulationEnabled(Boolean enabled) {
        Objects.requireNonNull(enabled, "enabled is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"enabled", (Object)enabled);
        return new Command("Emulation.setFocusEmulationEnabled", (Map)params.build());
    }

    @Beta
    public static Command<Void> setCPUThrottlingRate(Number rate) {
        Objects.requireNonNull(rate, "rate is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"rate", (Object)rate);
        return new Command("Emulation.setCPUThrottlingRate", (Map)params.build());
    }

    public static Command<Void> setDefaultBackgroundColorOverride(Optional<RGBA> color) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        color.ifPresent(p -> params.put((Object)"color", p));
        return new Command("Emulation.setDefaultBackgroundColorOverride", (Map)params.build());
    }

    public static Command<Void> setDeviceMetricsOverride(Integer width, Integer height, Number deviceScaleFactor, Boolean mobile, Optional<Number> scale, Optional<Integer> screenWidth, Optional<Integer> screenHeight, Optional<Integer> positionX, Optional<Integer> positionY, Optional<Boolean> dontSetVisibleSize, Optional<ScreenOrientation> screenOrientation, Optional<Viewport> viewport, Optional<DisplayFeature> displayFeature) {
        Objects.requireNonNull(width, "width is required");
        Objects.requireNonNull(height, "height is required");
        Objects.requireNonNull(deviceScaleFactor, "deviceScaleFactor is required");
        Objects.requireNonNull(mobile, "mobile is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"width", (Object)width);
        params.put((Object)"height", (Object)height);
        params.put((Object)"deviceScaleFactor", (Object)deviceScaleFactor);
        params.put((Object)"mobile", (Object)mobile);
        scale.ifPresent(p -> params.put((Object)"scale", p));
        screenWidth.ifPresent(p -> params.put((Object)"screenWidth", p));
        screenHeight.ifPresent(p -> params.put((Object)"screenHeight", p));
        positionX.ifPresent(p -> params.put((Object)"positionX", p));
        positionY.ifPresent(p -> params.put((Object)"positionY", p));
        dontSetVisibleSize.ifPresent(p -> params.put((Object)"dontSetVisibleSize", p));
        screenOrientation.ifPresent(p -> params.put((Object)"screenOrientation", p));
        viewport.ifPresent(p -> params.put((Object)"viewport", p));
        displayFeature.ifPresent(p -> params.put((Object)"displayFeature", p));
        return new Command("Emulation.setDeviceMetricsOverride", (Map)params.build());
    }

    @Beta
    public static Command<Void> setScrollbarsHidden(Boolean hidden) {
        Objects.requireNonNull(hidden, "hidden is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"hidden", (Object)hidden);
        return new Command("Emulation.setScrollbarsHidden", (Map)params.build());
    }

    @Beta
    public static Command<Void> setDocumentCookieDisabled(Boolean disabled) {
        Objects.requireNonNull(disabled, "disabled is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"disabled", (Object)disabled);
        return new Command("Emulation.setDocumentCookieDisabled", (Map)params.build());
    }

    @Beta
    public static Command<Void> setEmitTouchEventsForMouse(Boolean enabled, Optional<SetEmitTouchEventsForMouseConfiguration> configuration) {
        Objects.requireNonNull(enabled, "enabled is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"enabled", (Object)enabled);
        configuration.ifPresent(p -> params.put((Object)"configuration", (Object)p));
        return new Command("Emulation.setEmitTouchEventsForMouse", (Map)params.build());
    }

    public static Command<Void> setEmulatedMedia(Optional<String> media, Optional<List<MediaFeature>> features) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        media.ifPresent(p -> params.put((Object)"media", p));
        features.ifPresent(p -> params.put((Object)"features", p));
        return new Command("Emulation.setEmulatedMedia", (Map)params.build());
    }

    @Beta
    public static Command<Void> setEmulatedVisionDeficiency(SetEmulatedVisionDeficiencyType type) {
        Objects.requireNonNull(type, "type is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"type", (Object)type);
        return new Command("Emulation.setEmulatedVisionDeficiency", (Map)params.build());
    }

    public static Command<Void> setGeolocationOverride(Optional<Number> latitude, Optional<Number> longitude, Optional<Number> accuracy) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        latitude.ifPresent(p -> params.put((Object)"latitude", p));
        longitude.ifPresent(p -> params.put((Object)"longitude", p));
        accuracy.ifPresent(p -> params.put((Object)"accuracy", p));
        return new Command("Emulation.setGeolocationOverride", (Map)params.build());
    }

    @Beta
    public static Command<Void> setIdleOverride(Boolean isUserActive, Boolean isScreenUnlocked) {
        Objects.requireNonNull(isUserActive, "isUserActive is required");
        Objects.requireNonNull(isScreenUnlocked, "isScreenUnlocked is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"isUserActive", (Object)isUserActive);
        params.put((Object)"isScreenUnlocked", (Object)isScreenUnlocked);
        return new Command("Emulation.setIdleOverride", (Map)params.build());
    }

    @Beta
    public static Command<Void> clearIdleOverride() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Emulation.clearIdleOverride", (Map)params.build());
    }

    @Beta
    @Deprecated
    public static Command<Void> setNavigatorOverrides(String platform) {
        Objects.requireNonNull(platform, "platform is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"platform", (Object)platform);
        return new Command("Emulation.setNavigatorOverrides", (Map)params.build());
    }

    @Beta
    public static Command<Void> setPageScaleFactor(Number pageScaleFactor) {
        Objects.requireNonNull(pageScaleFactor, "pageScaleFactor is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"pageScaleFactor", (Object)pageScaleFactor);
        return new Command("Emulation.setPageScaleFactor", (Map)params.build());
    }

    public static Command<Void> setScriptExecutionDisabled(Boolean value) {
        Objects.requireNonNull(value, "value is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"value", (Object)value);
        return new Command("Emulation.setScriptExecutionDisabled", (Map)params.build());
    }

    public static Command<Void> setTouchEmulationEnabled(Boolean enabled, Optional<Integer> maxTouchPoints) {
        Objects.requireNonNull(enabled, "enabled is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"enabled", (Object)enabled);
        maxTouchPoints.ifPresent(p -> params.put((Object)"maxTouchPoints", p));
        return new Command("Emulation.setTouchEmulationEnabled", (Map)params.build());
    }

    @Beta
    public static Command<Number> setVirtualTimePolicy(VirtualTimePolicy policy, Optional<Number> budget, Optional<Integer> maxVirtualTimeTaskStarvationCount, Optional<Boolean> waitForNavigation, Optional<TimeSinceEpoch> initialVirtualTime) {
        Objects.requireNonNull(policy, "policy is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"policy", (Object)policy);
        budget.ifPresent(p -> params.put((Object)"budget", p));
        maxVirtualTimeTaskStarvationCount.ifPresent(p -> params.put((Object)"maxVirtualTimeTaskStarvationCount", p));
        waitForNavigation.ifPresent(p -> params.put((Object)"waitForNavigation", p));
        initialVirtualTime.ifPresent(p -> params.put((Object)"initialVirtualTime", p));
        return new Command("Emulation.setVirtualTimePolicy", (Map)params.build(), ConverterFunctions.map((String)"virtualTimeTicksBase", Number.class));
    }

    @Beta
    public static Command<Void> setLocaleOverride(Optional<String> locale) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        locale.ifPresent(p -> params.put((Object)"locale", p));
        return new Command("Emulation.setLocaleOverride", (Map)params.build());
    }

    @Beta
    public static Command<Void> setTimezoneOverride(String timezoneId) {
        Objects.requireNonNull(timezoneId, "timezoneId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"timezoneId", (Object)timezoneId);
        return new Command("Emulation.setTimezoneOverride", (Map)params.build());
    }

    @Beta
    @Deprecated
    public static Command<Void> setVisibleSize(Integer width, Integer height) {
        Objects.requireNonNull(width, "width is required");
        Objects.requireNonNull(height, "height is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"width", (Object)width);
        params.put((Object)"height", (Object)height);
        return new Command("Emulation.setVisibleSize", (Map)params.build());
    }

    @Beta
    public static Command<Void> setDisabledImageTypes(List<DisabledImageType> imageTypes) {
        Objects.requireNonNull(imageTypes, "imageTypes is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"imageTypes", imageTypes);
        return new Command("Emulation.setDisabledImageTypes", (Map)params.build());
    }

    public static Command<Void> setUserAgentOverride(String userAgent, Optional<String> acceptLanguage, Optional<String> platform, Optional<UserAgentMetadata> userAgentMetadata) {
        Objects.requireNonNull(userAgent, "userAgent is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"userAgent", (Object)userAgent);
        acceptLanguage.ifPresent(p -> params.put((Object)"acceptLanguage", p));
        platform.ifPresent(p -> params.put((Object)"platform", p));
        userAgentMetadata.ifPresent(p -> params.put((Object)"userAgentMetadata", p));
        return new Command("Emulation.setUserAgentOverride", (Map)params.build());
    }

    public static Event<Void> virtualTimeBudgetExpired() {
        return new Event("Emulation.virtualTimeBudgetExpired", input -> null);
    }

    public static enum SetEmulatedVisionDeficiencyType {
        NONE("none"),
        ACHROMATOPSIA("achromatopsia"),
        BLURREDVISION("blurredVision"),
        DEUTERANOPIA("deuteranopia"),
        PROTANOPIA("protanopia"),
        TRITANOPIA("tritanopia");

        private String value;

        private SetEmulatedVisionDeficiencyType(String value) {
            this.value = value;
        }

        public static SetEmulatedVisionDeficiencyType fromString(String s) {
            return Arrays.stream(SetEmulatedVisionDeficiencyType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within SetEmulatedVisionDeficiencyType "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static SetEmulatedVisionDeficiencyType fromJson(JsonInput input) {
            return SetEmulatedVisionDeficiencyType.fromString(input.nextString());
        }
    }

    public static enum SetEmitTouchEventsForMouseConfiguration {
        MOBILE("mobile"),
        DESKTOP("desktop");

        private String value;

        private SetEmitTouchEventsForMouseConfiguration(String value) {
            this.value = value;
        }

        public static SetEmitTouchEventsForMouseConfiguration fromString(String s) {
            return Arrays.stream(SetEmitTouchEventsForMouseConfiguration.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within SetEmitTouchEventsForMouseConfiguration "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static SetEmitTouchEventsForMouseConfiguration fromJson(JsonInput input) {
            return SetEmitTouchEventsForMouseConfiguration.fromString(input.nextString());
        }
    }
}

