/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v91.serviceworker.model;

import java.util.Objects;
import org.openqa.selenium.devtools.v91.serviceworker.model.RegistrationID;
import org.openqa.selenium.json.JsonInput;

public class ServiceWorkerRegistration {
    private final RegistrationID registrationId;
    private final String scopeURL;
    private final Boolean isDeleted;

    public ServiceWorkerRegistration(RegistrationID registrationId, String scopeURL, Boolean isDeleted) {
        this.registrationId = Objects.requireNonNull(registrationId, "registrationId is required");
        this.scopeURL = Objects.requireNonNull(scopeURL, "scopeURL is required");
        this.isDeleted = Objects.requireNonNull(isDeleted, "isDeleted is required");
    }

    public RegistrationID getRegistrationId() {
        return this.registrationId;
    }

    public String getScopeURL() {
        return this.scopeURL;
    }

    public Boolean getIsDeleted() {
        return this.isDeleted;
    }

    private static ServiceWorkerRegistration fromJson(JsonInput input) {
        RegistrationID registrationId = null;
        String scopeURL = null;
        Boolean isDeleted = false;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "registrationId": {
                    registrationId = (RegistrationID)input.read(RegistrationID.class);
                    continue block10;
                }
                case "scopeURL": {
                    scopeURL = input.nextString();
                    continue block10;
                }
                case "isDeleted": {
                    isDeleted = input.nextBoolean();
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new ServiceWorkerRegistration(registrationId, scopeURL, isDeleted);
    }
}

