/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v96.security.model;

import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v96.security.model.CertificateSecurityState;
import org.openqa.selenium.devtools.v96.security.model.SafetyTipInfo;
import org.openqa.selenium.devtools.v96.security.model.SecurityState;
import org.openqa.selenium.json.JsonInput;

@Beta
public class VisibleSecurityState {
    private final SecurityState securityState;
    private final Optional<CertificateSecurityState> certificateSecurityState;
    private final Optional<SafetyTipInfo> safetyTipInfo;
    private final List<String> securityStateIssueIds;

    public VisibleSecurityState(SecurityState securityState, Optional<CertificateSecurityState> certificateSecurityState, Optional<SafetyTipInfo> safetyTipInfo, List<String> securityStateIssueIds) {
        this.securityState = Objects.requireNonNull(securityState, "securityState is required");
        this.certificateSecurityState = certificateSecurityState;
        this.safetyTipInfo = safetyTipInfo;
        this.securityStateIssueIds = Objects.requireNonNull(securityStateIssueIds, "securityStateIssueIds is required");
    }

    public SecurityState getSecurityState() {
        return this.securityState;
    }

    public Optional<CertificateSecurityState> getCertificateSecurityState() {
        return this.certificateSecurityState;
    }

    public Optional<SafetyTipInfo> getSafetyTipInfo() {
        return this.safetyTipInfo;
    }

    public List<String> getSecurityStateIssueIds() {
        return this.securityStateIssueIds;
    }

    private static VisibleSecurityState fromJson(JsonInput input) {
        SecurityState securityState = null;
        Optional<CertificateSecurityState> certificateSecurityState = Optional.empty();
        Optional<SafetyTipInfo> safetyTipInfo = Optional.empty();
        List securityStateIssueIds = null;
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "securityState": {
                    securityState = (SecurityState)((Object)input.read(SecurityState.class));
                    continue block12;
                }
                case "certificateSecurityState": {
                    certificateSecurityState = Optional.ofNullable((CertificateSecurityState)input.read(CertificateSecurityState.class));
                    continue block12;
                }
                case "safetyTipInfo": {
                    safetyTipInfo = Optional.ofNullable((SafetyTipInfo)input.read(SafetyTipInfo.class));
                    continue block12;
                }
                case "securityStateIssueIds": {
                    securityStateIssueIds = (List)input.read(new TypeToken<List<String>>(){}.getType());
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new VisibleSecurityState(securityState, certificateSecurityState, safetyTipInfo, securityStateIssueIds);
    }
}

