package org.openqa.selenium.devtools.v97.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Information about the request initiator.
 */
public class Initiator {

    public enum Type {

        PARSER("parser"),
        SCRIPT("script"),
        PRELOAD("preload"),
        SIGNEDEXCHANGE("SignedExchange"),
        PREFLIGHT("preflight"),
        OTHER("other");

        private String value;

        Type(String value) {
            this.value = value;
        }

        public static Type fromString(String s) {
            return java.util.Arrays.stream(Type.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within Type "));
        }

        public String toString() {
            return value;
        }

        public String toJson() {
            return value;
        }

        private static Type fromJson(JsonInput input) {
            return fromString(input.nextString());
        }
    }

    private final Type type;

    private final java.util.Optional<org.openqa.selenium.devtools.v97.runtime.model.StackTrace> stack;

    private final java.util.Optional<java.lang.String> url;

    private final java.util.Optional<java.lang.Number> lineNumber;

    private final java.util.Optional<java.lang.Number> columnNumber;

    private final java.util.Optional<org.openqa.selenium.devtools.v97.network.model.RequestId> requestId;

    public Initiator(Type type, java.util.Optional<org.openqa.selenium.devtools.v97.runtime.model.StackTrace> stack, java.util.Optional<java.lang.String> url, java.util.Optional<java.lang.Number> lineNumber, java.util.Optional<java.lang.Number> columnNumber, java.util.Optional<org.openqa.selenium.devtools.v97.network.model.RequestId> requestId) {
        this.type = java.util.Objects.requireNonNull(type, "type is required");
        this.stack = stack;
        this.url = url;
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
        this.requestId = requestId;
    }

    /**
     * Type of this initiator.
     */
    public Type getType() {
        return type;
    }

    /**
     * Initiator JavaScript stack trace, set for Script only.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v97.runtime.model.StackTrace> getStack() {
        return stack;
    }

    /**
     * Initiator URL, set for Parser type or for Script type (when script is importing module) or for SignedExchange type.
     */
    public java.util.Optional<java.lang.String> getUrl() {
        return url;
    }

    /**
     * Initiator line number, set for Parser type or for Script type (when script is importing
     * module) (0-based).
     */
    public java.util.Optional<java.lang.Number> getLineNumber() {
        return lineNumber;
    }

    /**
     * Initiator column number, set for Parser type or for Script type (when script is importing
     * module) (0-based).
     */
    public java.util.Optional<java.lang.Number> getColumnNumber() {
        return columnNumber;
    }

    /**
     * Set if another request triggered this request (e.g. preflight).
     */
    public java.util.Optional<org.openqa.selenium.devtools.v97.network.model.RequestId> getRequestId() {
        return requestId;
    }

    private static Initiator fromJson(JsonInput input) {
        Type type = null;
        java.util.Optional<org.openqa.selenium.devtools.v97.runtime.model.StackTrace> stack = java.util.Optional.empty();
        java.util.Optional<java.lang.String> url = java.util.Optional.empty();
        java.util.Optional<java.lang.Number> lineNumber = java.util.Optional.empty();
        java.util.Optional<java.lang.Number> columnNumber = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v97.network.model.RequestId> requestId = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "type":
                    type = Type.fromString(input.nextString());
                    break;
                case "stack":
                    stack = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v97.runtime.model.StackTrace.class));
                    break;
                case "url":
                    url = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "lineNumber":
                    lineNumber = java.util.Optional.ofNullable(input.nextNumber());
                    break;
                case "columnNumber":
                    columnNumber = java.util.Optional.ofNullable(input.nextNumber());
                    break;
                case "requestId":
                    requestId = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v97.network.model.RequestId.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new Initiator(type, stack, url, lineNumber, columnNumber, requestId);
    }
}
