/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v99.css.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v99.css.model.SourceRange;
import org.openqa.selenium.devtools.v99.css.model.StyleSheetId;
import org.openqa.selenium.json.JsonInput;

@Beta
public class CSSContainerQuery {
    private final String text;
    private final Optional<SourceRange> range;
    private final Optional<StyleSheetId> styleSheetId;
    private final Optional<String> name;

    public CSSContainerQuery(String text, Optional<SourceRange> range, Optional<StyleSheetId> styleSheetId, Optional<String> name) {
        this.text = Objects.requireNonNull(text, "text is required");
        this.range = range;
        this.styleSheetId = styleSheetId;
        this.name = name;
    }

    public String getText() {
        return this.text;
    }

    public Optional<SourceRange> getRange() {
        return this.range;
    }

    public Optional<StyleSheetId> getStyleSheetId() {
        return this.styleSheetId;
    }

    public Optional<String> getName() {
        return this.name;
    }

    private static CSSContainerQuery fromJson(JsonInput input) {
        String text = null;
        Optional<SourceRange> range = Optional.empty();
        Optional<StyleSheetId> styleSheetId = Optional.empty();
        Optional<String> name = Optional.empty();
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "text": {
                    text = input.nextString();
                    continue block12;
                }
                case "range": {
                    range = Optional.ofNullable((SourceRange)input.read(SourceRange.class));
                    continue block12;
                }
                case "styleSheetId": {
                    styleSheetId = Optional.ofNullable((StyleSheetId)input.read(StyleSheetId.class));
                    continue block12;
                }
                case "name": {
                    name = Optional.ofNullable(input.nextString());
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new CSSContainerQuery(text, range, styleSheetId, name);
    }
}

