/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.fetch.model;

import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.fetch.model.AuthChallengeSource;
import org.openqa.selenium.json.JsonInput;

@Beta
public class AuthChallenge {
    private AuthChallengeSource source;
    private String origin;
    private String scheme;
    private String realm;

    public AuthChallenge(AuthChallengeSource source, String origin, String scheme, String realm) {
        this.source = source;
        this.origin = Objects.requireNonNull(origin, "origin is required");
        this.scheme = Objects.requireNonNull(scheme, "scheme is required");
        this.realm = Objects.requireNonNull(realm, "realm is required");
    }

    private static AuthChallenge fromJson(JsonInput input) {
        AuthChallengeSource source = null;
        String origin = null;
        String scheme = null;
        String realm = null;
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "source": {
                    source = (AuthChallengeSource)((Object)input.read(AuthChallengeSource.class));
                    continue block12;
                }
                case "origin": {
                    origin = input.nextString();
                    continue block12;
                }
                case "scheme": {
                    scheme = input.nextString();
                    continue block12;
                }
                case "realm": {
                    realm = input.nextString();
                }
            }
            input.nextString();
        }
        return new AuthChallenge(source, origin, scheme, realm);
    }
}

