/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.network.model;

import java.util.Objects;
import org.openqa.selenium.json.JsonInput;

public class CallFrame {
    private String functionName;
    private String scriptId;
    private String url;
    private Integer lineNumber;
    private Integer columnNumber;

    private CallFrame(String functionName, String scriptId, String url, Integer lineNumber, Integer columnNumber) {
        this.functionName = Objects.requireNonNull(functionName, "'functionName' is mandatory for CallFrame");
        this.scriptId = Objects.requireNonNull(scriptId, "'scriptId' is mandatory for CallFrame");
        this.url = Objects.requireNonNull(url, "'url' is mandatory for CallFrame");
        this.lineNumber = Objects.requireNonNull(lineNumber, "'lineNumber' is mandatory for CallFrame");
        this.columnNumber = Objects.requireNonNull(columnNumber, "'columnNumber' is mandatory for CallFrame");
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public String getScriptId() {
        return this.scriptId;
    }

    public void setScriptId(String scriptId) {
        this.scriptId = scriptId;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Integer getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(Integer lineNumber) {
        this.lineNumber = lineNumber;
    }

    public Integer getColumnNumber() {
        return this.columnNumber;
    }

    public void setColumnNumber(Integer columnNumber) {
        this.columnNumber = columnNumber;
    }

    private static CallFrame fromJson(JsonInput input) {
        String functionName = null;
        String scriptId = null;
        String callFrameUrl = null;
        Integer callFrameLineNumber = null;
        Integer columnNumber = null;
        input.beginObject();
        block14: while (input.hasNext()) {
            switch (input.nextName()) {
                case "functionName": {
                    functionName = input.nextString();
                    continue block14;
                }
                case "scriptId": {
                    scriptId = input.nextString();
                    continue block14;
                }
                case "url": {
                    callFrameUrl = input.nextString();
                    continue block14;
                }
                case "lineNumber": {
                    callFrameLineNumber = (Integer)input.read(Integer.class);
                    continue block14;
                }
                case "columnNumber": {
                    columnNumber = (Integer)input.read(Integer.class);
                    continue block14;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new CallFrame(functionName, scriptId, callFrameUrl, callFrameLineNumber, columnNumber);
    }
}

