/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.profiler.model;

import java.util.Objects;
import org.openqa.selenium.json.JsonInput;

public class Location {
    private final String scriptId;
    private final int lineNumber;
    private final Integer columnNumber;

    public Location(String scriptId, int lineNumber, Integer columnNumber) {
        Objects.requireNonNull(scriptId, "scriptId is require");
        this.scriptId = scriptId;
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
    }

    private static Location fromJson(JsonInput input) {
        String scriptId = input.nextString();
        int lineNumber = -1;
        Integer columnNumber = null;
        block8: while (input.hasNext()) {
            switch (input.nextName()) {
                case "lineNumber": {
                    lineNumber = (Integer)input.read(Integer.class);
                    continue block8;
                }
                case "columnNumber": {
                    columnNumber = (Integer)input.read(Integer.class);
                    continue block8;
                }
            }
            input.skipValue();
        }
        return new Location(scriptId, lineNumber, columnNumber);
    }

    public String getScriptId() {
        return this.scriptId;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public Integer getColumnNumber() {
        return this.columnNumber;
    }
}

