/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.dom.model;

import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Objects;
import org.openqa.selenium.devtools.dom.model.BackendNode;
import org.openqa.selenium.devtools.dom.model.BackendNodeId;
import org.openqa.selenium.devtools.dom.model.NodeId;
import org.openqa.selenium.devtools.dom.model.PseudoType;
import org.openqa.selenium.devtools.dom.model.ShadowRootType;
import org.openqa.selenium.devtools.page.model.FrameId;
import org.openqa.selenium.json.JsonInput;

public class Node {
    private final NodeId nodeId;
    private final NodeId parentId;
    private final BackendNodeId backendNodeId;
    private final Integer nodeType;
    private final String nodeName;
    private final String localName;
    private final String nodeValue;
    private final Integer childNodeCount;
    private final List<Node> children;
    private final List<String> attributes;
    private final String documentURL;
    private final String baseURL;
    private final String publicId;
    private final String systemId;
    private final String internalSubset;
    private final String xmlVersion;
    private final String name;
    private final String value;
    private final PseudoType pseudoType;
    private final ShadowRootType shadowRootType;
    private final FrameId frameId;
    private final Node contentDocument;
    private final List<Node> shadowRoots;
    private final Node templateContent;
    private final List<Node> pseudoElements;
    private final Node importedDocument;
    private final List<BackendNode> distributedNodes;
    private final Boolean isSVG;

    public Node(NodeId nodeId, NodeId parentId, BackendNodeId backendNodeId, Integer nodeType, String nodeName, String localName, String nodeValue, Integer childNodeCount, List<Node> children, List<String> attributes, String documentURL, String baseURL, String publicId, String systemId, String internalSubset, String xmlVersion, String name, String value, PseudoType pseudoType, ShadowRootType shadowRootType, FrameId frameId, Node contentDocument, List<Node> shadowRoots, Node templateContent, List<Node> pseudoElements, Node importedDocument, List<BackendNode> distributedNodes, Boolean isSVG) {
        this.nodeId = Objects.requireNonNull(nodeId, "nodeId is required");
        this.parentId = parentId;
        this.backendNodeId = Objects.requireNonNull(backendNodeId, "backendNodeId is required");
        this.nodeType = Objects.requireNonNull(nodeType, "nodeType is required");
        this.nodeName = Objects.requireNonNull(nodeName, "nodeName is required");
        this.localName = Objects.requireNonNull(localName, "localName is required");
        this.nodeValue = Objects.requireNonNull(nodeValue, "nodeValue is required");
        this.childNodeCount = childNodeCount;
        this.children = children;
        this.attributes = attributes;
        this.documentURL = documentURL;
        this.baseURL = baseURL;
        this.publicId = publicId;
        this.systemId = systemId;
        this.internalSubset = internalSubset;
        this.xmlVersion = xmlVersion;
        this.name = name;
        this.value = value;
        this.pseudoType = pseudoType;
        this.shadowRootType = shadowRootType;
        this.frameId = frameId;
        this.contentDocument = contentDocument;
        this.shadowRoots = shadowRoots;
        this.templateContent = templateContent;
        this.pseudoElements = pseudoElements;
        this.importedDocument = importedDocument;
        this.distributedNodes = distributedNodes;
        this.isSVG = isSVG;
    }

    public NodeId getNodeId() {
        return this.nodeId;
    }

    public NodeId getParentId() {
        return this.parentId;
    }

    public BackendNodeId getBackendNodeId() {
        return this.backendNodeId;
    }

    public Integer getNodeType() {
        return this.nodeType;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getNodeValue() {
        return this.nodeValue;
    }

    public Integer getChildNodeCount() {
        return this.childNodeCount;
    }

    public List<Node> getChildren() {
        return this.children;
    }

    public List<String> getAttributes() {
        return this.attributes;
    }

    public String getDocumentURL() {
        return this.documentURL;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public String getInternalSubset() {
        return this.internalSubset;
    }

    public String getXmlVersion() {
        return this.xmlVersion;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public PseudoType getPseudoType() {
        return this.pseudoType;
    }

    public ShadowRootType getShadowRootType() {
        return this.shadowRootType;
    }

    public FrameId getFrameId() {
        return this.frameId;
    }

    public Node getContentDocument() {
        return this.contentDocument;
    }

    public List<Node> getShadowRoots() {
        return this.shadowRoots;
    }

    public Node getTemplateContent() {
        return this.templateContent;
    }

    public List<Node> getPseudoElements() {
        return this.pseudoElements;
    }

    public Node getImportedDocument() {
        return this.importedDocument;
    }

    public List<BackendNode> getDistributedNodes() {
        return this.distributedNodes;
    }

    public Boolean getIsSVG() {
        return this.isSVG;
    }

    private static Node fromJson(JsonInput input) {
        NodeId nodeId = null;
        NodeId parentId = null;
        BackendNodeId backendNodeId = null;
        Integer nodeType = null;
        String nodeName = null;
        String localName = null;
        String nodeValue = null;
        Integer childNodeCount = null;
        List children = null;
        List attributes = null;
        String documentURL = null;
        String baseURL = null;
        String publicId = null;
        String systemId = null;
        String internalSubset = null;
        String xmlVersion = null;
        String name = null;
        String value = null;
        PseudoType pseudoType = null;
        ShadowRootType shadowRootType = null;
        FrameId frameId = null;
        Node contentDocument = null;
        List shadowRoots = null;
        Node templateContent = null;
        List pseudoElements = null;
        Node importedDocument = null;
        List distributedNodes = null;
        Boolean isSVG = null;
        input.beginObject();
        block60: while (input.hasNext()) {
            switch (input.nextName()) {
                case "nodeId": {
                    nodeId = (NodeId)input.read(NodeId.class);
                    continue block60;
                }
                case "parentId": {
                    parentId = (NodeId)input.read(NodeId.class);
                    continue block60;
                }
                case "backendNodeId": {
                    backendNodeId = (BackendNodeId)input.read(BackendNodeId.class);
                    continue block60;
                }
                case "nodeType": {
                    nodeType = input.nextNumber().intValue();
                    continue block60;
                }
                case "nodeName": {
                    nodeName = input.nextString();
                    continue block60;
                }
                case "localName": {
                    localName = input.nextString();
                    continue block60;
                }
                case "nodeValue": {
                    nodeValue = input.nextString();
                    continue block60;
                }
                case "childNodeCount": {
                    childNodeCount = input.nextNumber().intValue();
                    continue block60;
                }
                case "children": {
                    children = (List)input.read(new TypeToken<List<Node>>(){}.getType());
                    continue block60;
                }
                case "attributes": {
                    attributes = (List)input.read(new TypeToken<List<String>>(){}.getType());
                    continue block60;
                }
                case "documentURL": {
                    documentURL = input.nextString();
                    continue block60;
                }
                case "baseURL": {
                    baseURL = input.nextString();
                    continue block60;
                }
                case "publicId": {
                    publicId = input.nextString();
                    continue block60;
                }
                case "systemId": {
                    systemId = input.nextString();
                    continue block60;
                }
                case "internalSubset": {
                    internalSubset = input.nextString();
                    continue block60;
                }
                case "xmlVersion": {
                    xmlVersion = input.nextString();
                    continue block60;
                }
                case "name": {
                    name = input.nextString();
                    continue block60;
                }
                case "value": {
                    value = input.nextString();
                    continue block60;
                }
                case "pseudoType": {
                    pseudoType = (PseudoType)((Object)input.read(PseudoType.class));
                    continue block60;
                }
                case "shadowRootType": {
                    shadowRootType = (ShadowRootType)((Object)input.read(ShadowRootType.class));
                    continue block60;
                }
                case "frameId": {
                    frameId = (FrameId)input.read(FrameId.class);
                    continue block60;
                }
                case "contentDocument": {
                    contentDocument = (Node)input.read(Node.class);
                    continue block60;
                }
                case "shadowRoots": {
                    shadowRoots = (List)input.read(new TypeToken<List<Node>>(){}.getType());
                    continue block60;
                }
                case "templateContent": {
                    templateContent = (Node)input.read(Node.class);
                    continue block60;
                }
                case "pseudoElements": {
                    pseudoElements = (List)input.read(new TypeToken<List<Node>>(){}.getType());
                    continue block60;
                }
                case "importedDocument": {
                    importedDocument = (Node)input.read(Node.class);
                    continue block60;
                }
                case "distributedNodes": {
                    distributedNodes = (List)input.read(new TypeToken<List<BackendNode>>(){}.getType());
                    continue block60;
                }
                case "isSVG": {
                    isSVG = input.nextBoolean();
                    continue block60;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new Node(nodeId, parentId, backendNodeId, nodeType, nodeName, localName, nodeValue, childNodeCount, children, attributes, documentURL, baseURL, publicId, systemId, internalSubset, xmlVersion, name, value, pseudoType, shadowRootType, frameId, contentDocument, shadowRoots, templateContent, pseudoElements, importedDocument, distributedNodes, isSVG);
    }
}

