/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.indexeddb.model;

import com.google.common.reflect.TypeToken;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public class Key {
    private final Type type;
    private final Number number;
    private final String string;
    private final Number date;
    private final List<Key> array;

    public Key(Type type, Number number, String string, Number date, List<Key> array) {
        this.type = Objects.requireNonNull(type, "type is required");
        this.number = number;
        this.string = string;
        this.date = date;
        this.array = array;
    }

    public Type getType() {
        return this.type;
    }

    public Number getNumber() {
        return this.number;
    }

    public String getString() {
        return this.string;
    }

    public Number getDate() {
        return this.date;
    }

    public List<Key> getArray() {
        return this.array;
    }

    private static Key fromJson(JsonInput input) {
        Type type = null;
        Number number = null;
        String string = null;
        Number date = null;
        List array = null;
        input.beginObject();
        block14: while (input.hasNext()) {
            switch (input.nextName()) {
                case "type": {
                    type = Type.fromString(input.nextString());
                    continue block14;
                }
                case "number": {
                    number = input.nextNumber();
                    continue block14;
                }
                case "string": {
                    string = input.nextString();
                    continue block14;
                }
                case "date": {
                    date = input.nextNumber();
                    continue block14;
                }
                case "array": {
                    array = (List)input.read(new TypeToken<List<Key>>(){}.getType());
                    continue block14;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new Key(type, number, string, date, array);
    }

    public static enum Type {
        NUMBER("number"),
        STRING("string"),
        DATE("date"),
        ARRAY("array");

        private String value;

        private Type(String value) {
            this.value = value;
        }

        public static Type fromString(String s) {
            return Arrays.stream(Type.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within Type "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static Type fromJson(JsonInput input) {
            return Type.fromString(input.nextString());
        }
    }
}

