/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.network.model;

import java.util.Arrays;
import java.util.Objects;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.runtime.model.StackTrace;
import org.openqa.selenium.json.JsonInput;

public class Initiator {
    private final Type type;
    private final StackTrace stack;
    private final String url;
    private final Number lineNumber;

    public Initiator(Type type, StackTrace stack, String url, Number lineNumber) {
        this.type = Objects.requireNonNull(type, "type is required");
        this.stack = stack;
        this.url = url;
        this.lineNumber = lineNumber;
    }

    public Type getType() {
        return this.type;
    }

    public StackTrace getStack() {
        return this.stack;
    }

    public String getUrl() {
        return this.url;
    }

    public Number getLineNumber() {
        return this.lineNumber;
    }

    private static Initiator fromJson(JsonInput input) {
        Type type = null;
        StackTrace stack = null;
        String url = null;
        Number lineNumber = null;
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "type": {
                    type = Type.fromString(input.nextString());
                    continue block12;
                }
                case "stack": {
                    stack = (StackTrace)input.read(StackTrace.class);
                    continue block12;
                }
                case "url": {
                    url = input.nextString();
                    continue block12;
                }
                case "lineNumber": {
                    lineNumber = input.nextNumber();
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new Initiator(type, stack, url, lineNumber);
    }

    public static enum Type {
        PARSER("parser"),
        SCRIPT("script"),
        PRELOAD("preload"),
        SIGNEDEXCHANGE("SignedExchange"),
        OTHER("other");

        private String value;

        private Type(String value) {
            this.value = value;
        }

        public static Type fromString(String s) {
            return Arrays.stream(Type.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within Type "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static Type fromJson(JsonInput input) {
            return Type.fromString(input.nextString());
        }
    }
}

