/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.network.model;

import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.network.model.BlockedSetCookieWithReason;
import org.openqa.selenium.devtools.network.model.Headers;
import org.openqa.selenium.devtools.network.model.RequestId;
import org.openqa.selenium.json.JsonInput;

@Beta
public class ResponseReceivedExtraInfo {
    private final RequestId requestId;
    private final List<BlockedSetCookieWithReason> blockedCookies;
    private final Headers headers;
    private final String headersText;

    public ResponseReceivedExtraInfo(RequestId requestId, List<BlockedSetCookieWithReason> blockedCookies, Headers headers, String headersText) {
        this.requestId = Objects.requireNonNull(requestId, "requestId is required");
        this.blockedCookies = Objects.requireNonNull(blockedCookies, "blockedCookies is required");
        this.headers = Objects.requireNonNull(headers, "headers is required");
        this.headersText = headersText;
    }

    public RequestId getRequestId() {
        return this.requestId;
    }

    public List<BlockedSetCookieWithReason> getBlockedCookies() {
        return this.blockedCookies;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public String getHeadersText() {
        return this.headersText;
    }

    private static ResponseReceivedExtraInfo fromJson(JsonInput input) {
        RequestId requestId = null;
        List blockedCookies = null;
        Headers headers = null;
        String headersText = null;
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "requestId": {
                    requestId = (RequestId)input.read(RequestId.class);
                    continue block12;
                }
                case "blockedCookies": {
                    blockedCookies = (List)input.read(new TypeToken<List<BlockedSetCookieWithReason>>(){}.getType());
                    continue block12;
                }
                case "headers": {
                    headers = (Headers)((Object)input.read(Headers.class));
                    continue block12;
                }
                case "headersText": {
                    headersText = input.nextString();
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new ResponseReceivedExtraInfo(requestId, blockedCookies, headers, headersText);
    }
}

