/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.runtime.model;

import com.google.common.reflect.TypeToken;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.runtime.model.ExecutionContextId;
import org.openqa.selenium.devtools.runtime.model.RemoteObject;
import org.openqa.selenium.devtools.runtime.model.StackTrace;
import org.openqa.selenium.devtools.runtime.model.Timestamp;
import org.openqa.selenium.json.JsonInput;

public class ConsoleAPICalled {
    private final Type type;
    private final List<RemoteObject> args;
    private final ExecutionContextId executionContextId;
    private final Timestamp timestamp;
    private final StackTrace stackTrace;
    private final String context;

    public ConsoleAPICalled(Type type, List<RemoteObject> args, ExecutionContextId executionContextId, Timestamp timestamp, StackTrace stackTrace, String context) {
        this.type = Objects.requireNonNull(type, "type is required");
        this.args = Objects.requireNonNull(args, "args is required");
        this.executionContextId = Objects.requireNonNull(executionContextId, "executionContextId is required");
        this.timestamp = Objects.requireNonNull(timestamp, "timestamp is required");
        this.stackTrace = stackTrace;
        this.context = context;
    }

    public Type getType() {
        return this.type;
    }

    public List<RemoteObject> getArgs() {
        return this.args;
    }

    public ExecutionContextId getExecutionContextId() {
        return this.executionContextId;
    }

    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    public StackTrace getStackTrace() {
        return this.stackTrace;
    }

    @Beta
    public String getContext() {
        return this.context;
    }

    private static ConsoleAPICalled fromJson(JsonInput input) {
        Type type = null;
        List args = null;
        ExecutionContextId executionContextId = null;
        Timestamp timestamp = null;
        StackTrace stackTrace = null;
        String context = null;
        input.beginObject();
        block16: while (input.hasNext()) {
            switch (input.nextName()) {
                case "type": {
                    type = Type.fromString(input.nextString());
                    continue block16;
                }
                case "args": {
                    args = (List)input.read(new TypeToken<List<RemoteObject>>(){}.getType());
                    continue block16;
                }
                case "executionContextId": {
                    executionContextId = (ExecutionContextId)input.read(ExecutionContextId.class);
                    continue block16;
                }
                case "timestamp": {
                    timestamp = (Timestamp)input.read(Timestamp.class);
                    continue block16;
                }
                case "stackTrace": {
                    stackTrace = (StackTrace)input.read(StackTrace.class);
                    continue block16;
                }
                case "context": {
                    context = input.nextString();
                    continue block16;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new ConsoleAPICalled(type, args, executionContextId, timestamp, stackTrace, context);
    }

    public static enum Type {
        LOG("log"),
        DEBUG("debug"),
        INFO("info"),
        ERROR("error"),
        WARNING("warning"),
        DIR("dir"),
        DIRXML("dirxml"),
        TABLE("table"),
        TRACE("trace"),
        CLEAR("clear"),
        STARTGROUP("startGroup"),
        STARTGROUPCOLLAPSED("startGroupCollapsed"),
        ENDGROUP("endGroup"),
        ASSERT("assert"),
        PROFILE("profile"),
        PROFILEEND("profileEnd"),
        COUNT("count"),
        TIMEEND("timeEnd");

        private String value;

        private Type(String value) {
            this.value = value;
        }

        public static Type fromString(String s) {
            return Arrays.stream(Type.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within Type "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static Type fromJson(JsonInput input) {
            return Type.fromString(input.nextString());
        }
    }
}

