/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.systeminfo.model;

import java.util.Objects;
import org.openqa.selenium.json.JsonInput;

public class GPUDevice {
    private final Number vendorId;
    private final Number deviceId;
    private final String vendorString;
    private final String deviceString;
    private final String driverVendor;
    private final String driverVersion;

    public GPUDevice(Number vendorId, Number deviceId, String vendorString, String deviceString, String driverVendor, String driverVersion) {
        this.vendorId = Objects.requireNonNull(vendorId, "vendorId is required");
        this.deviceId = Objects.requireNonNull(deviceId, "deviceId is required");
        this.vendorString = Objects.requireNonNull(vendorString, "vendorString is required");
        this.deviceString = Objects.requireNonNull(deviceString, "deviceString is required");
        this.driverVendor = Objects.requireNonNull(driverVendor, "driverVendor is required");
        this.driverVersion = Objects.requireNonNull(driverVersion, "driverVersion is required");
    }

    public Number getVendorId() {
        return this.vendorId;
    }

    public Number getDeviceId() {
        return this.deviceId;
    }

    public String getVendorString() {
        return this.vendorString;
    }

    public String getDeviceString() {
        return this.deviceString;
    }

    public String getDriverVendor() {
        return this.driverVendor;
    }

    public String getDriverVersion() {
        return this.driverVersion;
    }

    private static GPUDevice fromJson(JsonInput input) {
        Number vendorId = null;
        Number deviceId = null;
        String vendorString = null;
        String deviceString = null;
        String driverVendor = null;
        String driverVersion = null;
        input.beginObject();
        block16: while (input.hasNext()) {
            switch (input.nextName()) {
                case "vendorId": {
                    vendorId = input.nextNumber();
                    continue block16;
                }
                case "deviceId": {
                    deviceId = input.nextNumber();
                    continue block16;
                }
                case "vendorString": {
                    vendorString = input.nextString();
                    continue block16;
                }
                case "deviceString": {
                    deviceString = input.nextString();
                    continue block16;
                }
                case "driverVendor": {
                    driverVendor = input.nextString();
                    continue block16;
                }
                case "driverVersion": {
                    driverVersion = input.nextString();
                    continue block16;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new GPUDevice(vendorId, deviceId, vendorString, deviceString, driverVendor, driverVersion);
    }
}

