/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.tracing.model;

import java.util.Objects;
import org.openqa.selenium.devtools.io.model.StreamHandle;
import org.openqa.selenium.devtools.tracing.model.StreamCompression;
import org.openqa.selenium.devtools.tracing.model.StreamFormat;
import org.openqa.selenium.json.JsonInput;

public class TracingComplete {
    private final Boolean dataLossOccurred;
    private final StreamHandle stream;
    private final StreamFormat traceFormat;
    private final StreamCompression streamCompression;

    public TracingComplete(Boolean dataLossOccurred, StreamHandle stream, StreamFormat traceFormat, StreamCompression streamCompression) {
        this.dataLossOccurred = Objects.requireNonNull(dataLossOccurred, "dataLossOccurred is required");
        this.stream = stream;
        this.traceFormat = traceFormat;
        this.streamCompression = streamCompression;
    }

    public Boolean getDataLossOccurred() {
        return this.dataLossOccurred;
    }

    public StreamHandle getStream() {
        return this.stream;
    }

    public StreamFormat getTraceFormat() {
        return this.traceFormat;
    }

    public StreamCompression getStreamCompression() {
        return this.streamCompression;
    }

    private static TracingComplete fromJson(JsonInput input) {
        Boolean dataLossOccurred = null;
        StreamHandle stream = null;
        StreamFormat traceFormat = null;
        StreamCompression streamCompression = null;
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "dataLossOccurred": {
                    dataLossOccurred = input.nextBoolean();
                    continue block12;
                }
                case "stream": {
                    stream = (StreamHandle)input.read(StreamHandle.class);
                    continue block12;
                }
                case "traceFormat": {
                    traceFormat = (StreamFormat)((Object)input.read(StreamFormat.class));
                    continue block12;
                }
                case "streamCompression": {
                    streamCompression = (StreamCompression)((Object)input.read(StreamCompression.class));
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new TracingComplete(dataLossOccurred, stream, traceFormat, streamCompression);
    }
}

