/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.css.model;

import java.util.Objects;
import org.openqa.selenium.devtools.css.model.StyleSheetId;
import org.openqa.selenium.devtools.css.model.StyleSheetOrigin;
import org.openqa.selenium.devtools.dom.model.BackendNodeId;
import org.openqa.selenium.devtools.page.model.FrameId;
import org.openqa.selenium.json.JsonInput;

public class CSSStyleSheetHeader {
    private final StyleSheetId styleSheetId;
    private final FrameId frameId;
    private final String sourceURL;
    private final String sourceMapURL;
    private final StyleSheetOrigin origin;
    private final String title;
    private final BackendNodeId ownerNode;
    private final Boolean disabled;
    private final Boolean hasSourceURL;
    private final Boolean isInline;
    private final Number startLine;
    private final Number startColumn;
    private final Number length;

    public CSSStyleSheetHeader(StyleSheetId styleSheetId, FrameId frameId, String sourceURL, String sourceMapURL, StyleSheetOrigin origin, String title, BackendNodeId ownerNode, Boolean disabled, Boolean hasSourceURL, Boolean isInline, Number startLine, Number startColumn, Number length) {
        this.styleSheetId = Objects.requireNonNull(styleSheetId, "styleSheetId is required");
        this.frameId = Objects.requireNonNull(frameId, "frameId is required");
        this.sourceURL = Objects.requireNonNull(sourceURL, "sourceURL is required");
        this.sourceMapURL = sourceMapURL;
        this.origin = Objects.requireNonNull(origin, "origin is required");
        this.title = Objects.requireNonNull(title, "title is required");
        this.ownerNode = ownerNode;
        this.disabled = Objects.requireNonNull(disabled, "disabled is required");
        this.hasSourceURL = hasSourceURL;
        this.isInline = Objects.requireNonNull(isInline, "isInline is required");
        this.startLine = Objects.requireNonNull(startLine, "startLine is required");
        this.startColumn = Objects.requireNonNull(startColumn, "startColumn is required");
        this.length = Objects.requireNonNull(length, "length is required");
    }

    public StyleSheetId getStyleSheetId() {
        return this.styleSheetId;
    }

    public FrameId getFrameId() {
        return this.frameId;
    }

    public String getSourceURL() {
        return this.sourceURL;
    }

    public String getSourceMapURL() {
        return this.sourceMapURL;
    }

    public StyleSheetOrigin getOrigin() {
        return this.origin;
    }

    public String getTitle() {
        return this.title;
    }

    public BackendNodeId getOwnerNode() {
        return this.ownerNode;
    }

    public Boolean getDisabled() {
        return this.disabled;
    }

    public Boolean getHasSourceURL() {
        return this.hasSourceURL;
    }

    public Boolean getIsInline() {
        return this.isInline;
    }

    public Number getStartLine() {
        return this.startLine;
    }

    public Number getStartColumn() {
        return this.startColumn;
    }

    public Number getLength() {
        return this.length;
    }

    private static CSSStyleSheetHeader fromJson(JsonInput input) {
        StyleSheetId styleSheetId = null;
        FrameId frameId = null;
        String sourceURL = null;
        String sourceMapURL = null;
        StyleSheetOrigin origin = null;
        String title = null;
        BackendNodeId ownerNode = null;
        Boolean disabled = null;
        Boolean hasSourceURL = null;
        Boolean isInline = null;
        Number startLine = null;
        Number startColumn = null;
        Number length = null;
        input.beginObject();
        block30: while (input.hasNext()) {
            switch (input.nextName()) {
                case "styleSheetId": {
                    styleSheetId = (StyleSheetId)input.read(StyleSheetId.class);
                    continue block30;
                }
                case "frameId": {
                    frameId = (FrameId)input.read(FrameId.class);
                    continue block30;
                }
                case "sourceURL": {
                    sourceURL = input.nextString();
                    continue block30;
                }
                case "sourceMapURL": {
                    sourceMapURL = input.nextString();
                    continue block30;
                }
                case "origin": {
                    origin = (StyleSheetOrigin)((Object)input.read(StyleSheetOrigin.class));
                    continue block30;
                }
                case "title": {
                    title = input.nextString();
                    continue block30;
                }
                case "ownerNode": {
                    ownerNode = (BackendNodeId)input.read(BackendNodeId.class);
                    continue block30;
                }
                case "disabled": {
                    disabled = input.nextBoolean();
                    continue block30;
                }
                case "hasSourceURL": {
                    hasSourceURL = input.nextBoolean();
                    continue block30;
                }
                case "isInline": {
                    isInline = input.nextBoolean();
                    continue block30;
                }
                case "startLine": {
                    startLine = input.nextNumber();
                    continue block30;
                }
                case "startColumn": {
                    startColumn = input.nextNumber();
                    continue block30;
                }
                case "length": {
                    length = input.nextNumber();
                    continue block30;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new CSSStyleSheetHeader(styleSheetId, frameId, sourceURL, sourceMapURL, origin, title, ownerNode, disabled, hasSourceURL, isInline, startLine, startColumn, length);
    }
}

