/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.page.model;

import java.util.Objects;
import org.openqa.selenium.devtools.page.model.DialogType;
import org.openqa.selenium.json.JsonInput;

public class JavascriptDialogOpening {
    private final String url;
    private final String message;
    private final DialogType type;
    private final Boolean hasBrowserHandler;
    private final String defaultPrompt;

    public JavascriptDialogOpening(String url, String message, DialogType type, Boolean hasBrowserHandler, String defaultPrompt) {
        this.url = Objects.requireNonNull(url, "url is required");
        this.message = Objects.requireNonNull(message, "message is required");
        this.type = Objects.requireNonNull(type, "type is required");
        this.hasBrowserHandler = Objects.requireNonNull(hasBrowserHandler, "hasBrowserHandler is required");
        this.defaultPrompt = defaultPrompt;
    }

    public String getUrl() {
        return this.url;
    }

    public String getMessage() {
        return this.message;
    }

    public DialogType getType() {
        return this.type;
    }

    public Boolean getHasBrowserHandler() {
        return this.hasBrowserHandler;
    }

    public String getDefaultPrompt() {
        return this.defaultPrompt;
    }

    private static JavascriptDialogOpening fromJson(JsonInput input) {
        String url = null;
        String message = null;
        DialogType type = null;
        Boolean hasBrowserHandler = null;
        String defaultPrompt = null;
        input.beginObject();
        block14: while (input.hasNext()) {
            switch (input.nextName()) {
                case "url": {
                    url = input.nextString();
                    continue block14;
                }
                case "message": {
                    message = input.nextString();
                    continue block14;
                }
                case "type": {
                    type = (DialogType)((Object)input.read(DialogType.class));
                    continue block14;
                }
                case "hasBrowserHandler": {
                    hasBrowserHandler = input.nextBoolean();
                    continue block14;
                }
                case "defaultPrompt": {
                    defaultPrompt = input.nextString();
                    continue block14;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new JavascriptDialogOpening(url, message, type, hasBrowserHandler, defaultPrompt);
    }
}

