/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.profiler.model;

import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Objects;
import org.openqa.selenium.devtools.profiler.model.PositionTickInfo;
import org.openqa.selenium.devtools.runtime.model.CallFrame;
import org.openqa.selenium.json.JsonInput;

public class ProfileNode {
    private final Integer id;
    private final CallFrame callFrame;
    private final Integer hitCount;
    private final List<Integer> children;
    private final String deoptReason;
    private final List<PositionTickInfo> positionTicks;

    public ProfileNode(Integer id, CallFrame callFrame, Integer hitCount, List<Integer> children, String deoptReason, List<PositionTickInfo> positionTicks) {
        this.id = Objects.requireNonNull(id, "id is required");
        this.callFrame = Objects.requireNonNull(callFrame, "callFrame is required");
        this.hitCount = hitCount;
        this.children = children;
        this.deoptReason = deoptReason;
        this.positionTicks = positionTicks;
    }

    public Integer getId() {
        return this.id;
    }

    public CallFrame getCallFrame() {
        return this.callFrame;
    }

    public Integer getHitCount() {
        return this.hitCount;
    }

    public List<Integer> getChildren() {
        return this.children;
    }

    public String getDeoptReason() {
        return this.deoptReason;
    }

    public List<PositionTickInfo> getPositionTicks() {
        return this.positionTicks;
    }

    private static ProfileNode fromJson(JsonInput input) {
        Integer id = null;
        CallFrame callFrame = null;
        Integer hitCount = null;
        List children = null;
        String deoptReason = null;
        List positionTicks = null;
        input.beginObject();
        block16: while (input.hasNext()) {
            switch (input.nextName()) {
                case "id": {
                    id = input.nextNumber().intValue();
                    continue block16;
                }
                case "callFrame": {
                    callFrame = (CallFrame)input.read(CallFrame.class);
                    continue block16;
                }
                case "hitCount": {
                    hitCount = input.nextNumber().intValue();
                    continue block16;
                }
                case "children": {
                    children = (List)input.read(new TypeToken<List<Integer>>(){}.getType());
                    continue block16;
                }
                case "deoptReason": {
                    deoptReason = input.nextString();
                    continue block16;
                }
                case "positionTicks": {
                    positionTicks = (List)input.read(new TypeToken<List<PositionTickInfo>>(){}.getType());
                    continue block16;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new ProfileNode(id, callFrame, hitCount, children, deoptReason, positionTicks);
    }
}

