/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.target.model;

import java.util.Objects;
import org.openqa.selenium.devtools.target.model.SessionID;
import org.openqa.selenium.devtools.target.model.TargetID;
import org.openqa.selenium.json.JsonInput;

public class ReceivedMessageFromTarget {
    private final SessionID sessionId;
    private final String message;
    private final TargetID targetId;

    public ReceivedMessageFromTarget(SessionID sessionId, String message, TargetID targetId) {
        this.sessionId = Objects.requireNonNull(sessionId, "sessionId is required");
        this.message = Objects.requireNonNull(message, "message is required");
        this.targetId = targetId;
    }

    public SessionID getSessionId() {
        return this.sessionId;
    }

    public String getMessage() {
        return this.message;
    }

    @Deprecated
    public TargetID getTargetId() {
        return this.targetId;
    }

    private static ReceivedMessageFromTarget fromJson(JsonInput input) {
        SessionID sessionId = null;
        String message = null;
        TargetID targetId = null;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "sessionId": {
                    sessionId = (SessionID)input.read(SessionID.class);
                    continue block10;
                }
                case "message": {
                    message = input.nextString();
                    continue block10;
                }
                case "targetId": {
                    targetId = (TargetID)input.read(TargetID.class);
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new ReceivedMessageFromTarget(sessionId, message, targetId);
    }
}

