/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.applicationcache;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.applicationcache.model.ApplicationCacheStatusUpdated;
import org.openqa.selenium.devtools.applicationcache.model.FrameWithManifest;
import org.openqa.selenium.devtools.page.model.FrameId;

@Beta
public class ApplicationCache {
    public static Command<Void> enable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("ApplicationCache.enable", (Map<String, Object>)params.build());
    }

    public static Command<org.openqa.selenium.devtools.applicationcache.model.ApplicationCache> getApplicationCacheForFrame(FrameId frameId) {
        Objects.requireNonNull(frameId, "frameId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"frameId", (Object)frameId);
        return new Command<org.openqa.selenium.devtools.applicationcache.model.ApplicationCache>("ApplicationCache.getApplicationCacheForFrame", (Map<String, Object>)params.build(), ConverterFunctions.map("applicationCache", org.openqa.selenium.devtools.applicationcache.model.ApplicationCache.class));
    }

    public static Command<List<FrameWithManifest>> getFramesWithManifests() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<List<FrameWithManifest>>("ApplicationCache.getFramesWithManifests", (Map<String, Object>)params.build(), ConverterFunctions.map("frameIds", new TypeToken<List<FrameWithManifest>>(){}.getType()));
    }

    public static Command<String> getManifestForFrame(FrameId frameId) {
        Objects.requireNonNull(frameId, "frameId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"frameId", (Object)frameId);
        return new Command<String>("ApplicationCache.getManifestForFrame", (Map<String, Object>)params.build(), ConverterFunctions.map("manifestURL", String.class));
    }

    public static Event<ApplicationCacheStatusUpdated> applicationCacheStatusUpdated() {
        return new Event<ApplicationCacheStatusUpdated>("ApplicationCache.applicationCacheStatusUpdated", input -> (ApplicationCacheStatusUpdated)input.read(ApplicationCacheStatusUpdated.class));
    }

    public static Event<Boolean> networkStateUpdated() {
        return new Event<Boolean>("ApplicationCache.networkStateUpdated", ConverterFunctions.map("isNowOnline", Boolean.class));
    }
}

