/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.audits.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.audits.model.AffectedFrame;
import org.openqa.selenium.devtools.audits.model.AffectedRequest;
import org.openqa.selenium.devtools.audits.model.MixedContentResolutionStatus;
import org.openqa.selenium.devtools.audits.model.MixedContentResourceType;
import org.openqa.selenium.json.JsonInput;

public class MixedContentIssueDetails {
    private final Optional<MixedContentResourceType> resourceType;
    private final MixedContentResolutionStatus resolutionStatus;
    private final String insecureURL;
    private final String mainResourceURL;
    private final Optional<AffectedRequest> request;
    private final Optional<AffectedFrame> frame;

    public MixedContentIssueDetails(Optional<MixedContentResourceType> resourceType, MixedContentResolutionStatus resolutionStatus, String insecureURL, String mainResourceURL, Optional<AffectedRequest> request, Optional<AffectedFrame> frame) {
        this.resourceType = resourceType;
        this.resolutionStatus = Objects.requireNonNull(resolutionStatus, "resolutionStatus is required");
        this.insecureURL = Objects.requireNonNull(insecureURL, "insecureURL is required");
        this.mainResourceURL = Objects.requireNonNull(mainResourceURL, "mainResourceURL is required");
        this.request = request;
        this.frame = frame;
    }

    public Optional<MixedContentResourceType> getResourceType() {
        return this.resourceType;
    }

    public MixedContentResolutionStatus getResolutionStatus() {
        return this.resolutionStatus;
    }

    public String getInsecureURL() {
        return this.insecureURL;
    }

    public String getMainResourceURL() {
        return this.mainResourceURL;
    }

    public Optional<AffectedRequest> getRequest() {
        return this.request;
    }

    public Optional<AffectedFrame> getFrame() {
        return this.frame;
    }

    private static MixedContentIssueDetails fromJson(JsonInput input) {
        Optional<MixedContentResourceType> resourceType = Optional.empty();
        MixedContentResolutionStatus resolutionStatus = null;
        String insecureURL = null;
        String mainResourceURL = null;
        Optional<AffectedRequest> request = Optional.empty();
        Optional<AffectedFrame> frame = Optional.empty();
        input.beginObject();
        block16: while (input.hasNext()) {
            switch (input.nextName()) {
                case "resourceType": {
                    resourceType = Optional.ofNullable((MixedContentResourceType)((Object)input.read(MixedContentResourceType.class)));
                    continue block16;
                }
                case "resolutionStatus": {
                    resolutionStatus = (MixedContentResolutionStatus)((Object)input.read(MixedContentResolutionStatus.class));
                    continue block16;
                }
                case "insecureURL": {
                    insecureURL = input.nextString();
                    continue block16;
                }
                case "mainResourceURL": {
                    mainResourceURL = input.nextString();
                    continue block16;
                }
                case "request": {
                    request = Optional.ofNullable((AffectedRequest)input.read(AffectedRequest.class));
                    continue block16;
                }
                case "frame": {
                    frame = Optional.ofNullable((AffectedFrame)input.read(AffectedFrame.class));
                    continue block16;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new MixedContentIssueDetails(resourceType, resolutionStatus, insecureURL, mainResourceURL, request, frame);
    }
}

