/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.dom;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.dom.model.AttributeModified;
import org.openqa.selenium.devtools.dom.model.AttributeRemoved;
import org.openqa.selenium.devtools.dom.model.BackendNodeId;
import org.openqa.selenium.devtools.dom.model.BoxModel;
import org.openqa.selenium.devtools.dom.model.CharacterDataModified;
import org.openqa.selenium.devtools.dom.model.ChildNodeCountUpdated;
import org.openqa.selenium.devtools.dom.model.ChildNodeInserted;
import org.openqa.selenium.devtools.dom.model.ChildNodeRemoved;
import org.openqa.selenium.devtools.dom.model.DistributedNodesUpdated;
import org.openqa.selenium.devtools.dom.model.Node;
import org.openqa.selenium.devtools.dom.model.NodeId;
import org.openqa.selenium.devtools.dom.model.PseudoElementAdded;
import org.openqa.selenium.devtools.dom.model.PseudoElementRemoved;
import org.openqa.selenium.devtools.dom.model.Quad;
import org.openqa.selenium.devtools.dom.model.Rect;
import org.openqa.selenium.devtools.dom.model.SetChildNodes;
import org.openqa.selenium.devtools.dom.model.ShadowRootPopped;
import org.openqa.selenium.devtools.dom.model.ShadowRootPushed;
import org.openqa.selenium.devtools.page.model.FrameId;
import org.openqa.selenium.devtools.runtime.model.ExecutionContextId;
import org.openqa.selenium.devtools.runtime.model.RemoteObject;
import org.openqa.selenium.devtools.runtime.model.RemoteObjectId;
import org.openqa.selenium.devtools.runtime.model.StackTrace;
import org.openqa.selenium.json.JsonInput;

public class DOM {
    @Beta
    public static Command<List<String>> collectClassNamesFromSubtree(NodeId nodeId) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"nodeId", (Object)nodeId);
        return new Command<List<String>>("DOM.collectClassNamesFromSubtree", (Map<String, Object>)params.build(), ConverterFunctions.map("classNames", new TypeToken<List<String>>(){}.getType()));
    }

    @Beta
    public static Command<NodeId> copyTo(NodeId nodeId, NodeId targetNodeId, Optional<NodeId> insertBeforeNodeId) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        Objects.requireNonNull(targetNodeId, "targetNodeId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"nodeId", (Object)nodeId);
        params.put((Object)"targetNodeId", (Object)targetNodeId);
        insertBeforeNodeId.ifPresent(p -> params.put((Object)"insertBeforeNodeId", p));
        return new Command<NodeId>("DOM.copyTo", (Map<String, Object>)params.build(), ConverterFunctions.map("nodeId", NodeId.class));
    }

    public static Command<Node> describeNode(Optional<NodeId> nodeId, Optional<BackendNodeId> backendNodeId, Optional<RemoteObjectId> objectId, Optional<Integer> depth, Optional<Boolean> pierce) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        nodeId.ifPresent(p -> params.put((Object)"nodeId", p));
        backendNodeId.ifPresent(p -> params.put((Object)"backendNodeId", p));
        objectId.ifPresent(p -> params.put((Object)"objectId", p));
        depth.ifPresent(p -> params.put((Object)"depth", p));
        pierce.ifPresent(p -> params.put((Object)"pierce", p));
        return new Command<Node>("DOM.describeNode", (Map<String, Object>)params.build(), ConverterFunctions.map("node", Node.class));
    }

    @Beta
    public static Command<Void> scrollIntoViewIfNeeded(Optional<NodeId> nodeId, Optional<BackendNodeId> backendNodeId, Optional<RemoteObjectId> objectId, Optional<Rect> rect) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        nodeId.ifPresent(p -> params.put((Object)"nodeId", p));
        backendNodeId.ifPresent(p -> params.put((Object)"backendNodeId", p));
        objectId.ifPresent(p -> params.put((Object)"objectId", p));
        rect.ifPresent(p -> params.put((Object)"rect", p));
        return new Command<Void>("DOM.scrollIntoViewIfNeeded", (Map<String, Object>)params.build());
    }

    public static Command<Void> disable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("DOM.disable", (Map<String, Object>)params.build());
    }

    @Beta
    public static Command<Void> discardSearchResults(String searchId) {
        Objects.requireNonNull(searchId, "searchId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"searchId", (Object)searchId);
        return new Command<Void>("DOM.discardSearchResults", (Map<String, Object>)params.build());
    }

    public static Command<Void> enable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("DOM.enable", (Map<String, Object>)params.build());
    }

    public static Command<Void> focus(Optional<NodeId> nodeId, Optional<BackendNodeId> backendNodeId, Optional<RemoteObjectId> objectId) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        nodeId.ifPresent(p -> params.put((Object)"nodeId", p));
        backendNodeId.ifPresent(p -> params.put((Object)"backendNodeId", p));
        objectId.ifPresent(p -> params.put((Object)"objectId", p));
        return new Command<Void>("DOM.focus", (Map<String, Object>)params.build());
    }

    public static Command<List<String>> getAttributes(NodeId nodeId) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"nodeId", (Object)nodeId);
        return new Command<List<String>>("DOM.getAttributes", (Map<String, Object>)params.build(), ConverterFunctions.map("attributes", new TypeToken<List<String>>(){}.getType()));
    }

    public static Command<BoxModel> getBoxModel(Optional<NodeId> nodeId, Optional<BackendNodeId> backendNodeId, Optional<RemoteObjectId> objectId) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        nodeId.ifPresent(p -> params.put((Object)"nodeId", p));
        backendNodeId.ifPresent(p -> params.put((Object)"backendNodeId", p));
        objectId.ifPresent(p -> params.put((Object)"objectId", p));
        return new Command<BoxModel>("DOM.getBoxModel", (Map<String, Object>)params.build(), ConverterFunctions.map("model", BoxModel.class));
    }

    @Beta
    public static Command<List<Quad>> getContentQuads(Optional<NodeId> nodeId, Optional<BackendNodeId> backendNodeId, Optional<RemoteObjectId> objectId) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        nodeId.ifPresent(p -> params.put((Object)"nodeId", p));
        backendNodeId.ifPresent(p -> params.put((Object)"backendNodeId", p));
        objectId.ifPresent(p -> params.put((Object)"objectId", p));
        return new Command<List<Quad>>("DOM.getContentQuads", (Map<String, Object>)params.build(), ConverterFunctions.map("quads", new TypeToken<List<Quad>>(){}.getType()));
    }

    public static Command<Node> getDocument(Optional<Integer> depth, Optional<Boolean> pierce) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        depth.ifPresent(p -> params.put((Object)"depth", p));
        pierce.ifPresent(p -> params.put((Object)"pierce", p));
        return new Command<Node>("DOM.getDocument", (Map<String, Object>)params.build(), ConverterFunctions.map("root", Node.class));
    }

    public static Command<List<Node>> getFlattenedDocument(Optional<Integer> depth, Optional<Boolean> pierce) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        depth.ifPresent(p -> params.put((Object)"depth", p));
        pierce.ifPresent(p -> params.put((Object)"pierce", p));
        return new Command<List<Node>>("DOM.getFlattenedDocument", (Map<String, Object>)params.build(), ConverterFunctions.map("nodes", new TypeToken<List<Node>>(){}.getType()));
    }

    public static Command<GetNodeForLocationResponse> getNodeForLocation(Integer x, Integer y, Optional<Boolean> includeUserAgentShadowDOM, Optional<Boolean> ignorePointerEventsNone) {
        Objects.requireNonNull(x, "x is required");
        Objects.requireNonNull(y, "y is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"x", (Object)x);
        params.put((Object)"y", (Object)y);
        includeUserAgentShadowDOM.ifPresent(p -> params.put((Object)"includeUserAgentShadowDOM", p));
        ignorePointerEventsNone.ifPresent(p -> params.put((Object)"ignorePointerEventsNone", p));
        return new Command<GetNodeForLocationResponse>("DOM.getNodeForLocation", (Map<String, Object>)params.build(), input -> (GetNodeForLocationResponse)input.read(GetNodeForLocationResponse.class));
    }

    public static Command<String> getOuterHTML(Optional<NodeId> nodeId, Optional<BackendNodeId> backendNodeId, Optional<RemoteObjectId> objectId) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        nodeId.ifPresent(p -> params.put((Object)"nodeId", p));
        backendNodeId.ifPresent(p -> params.put((Object)"backendNodeId", p));
        objectId.ifPresent(p -> params.put((Object)"objectId", p));
        return new Command<String>("DOM.getOuterHTML", (Map<String, Object>)params.build(), ConverterFunctions.map("outerHTML", String.class));
    }

    @Beta
    public static Command<NodeId> getRelayoutBoundary(NodeId nodeId) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"nodeId", (Object)nodeId);
        return new Command<NodeId>("DOM.getRelayoutBoundary", (Map<String, Object>)params.build(), ConverterFunctions.map("nodeId", NodeId.class));
    }

    @Beta
    public static Command<List<NodeId>> getSearchResults(String searchId, Integer fromIndex, Integer toIndex) {
        Objects.requireNonNull(searchId, "searchId is required");
        Objects.requireNonNull(fromIndex, "fromIndex is required");
        Objects.requireNonNull(toIndex, "toIndex is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"searchId", (Object)searchId);
        params.put((Object)"fromIndex", (Object)fromIndex);
        params.put((Object)"toIndex", (Object)toIndex);
        return new Command<List<NodeId>>("DOM.getSearchResults", (Map<String, Object>)params.build(), ConverterFunctions.map("nodeIds", new TypeToken<List<NodeId>>(){}.getType()));
    }

    public static Command<Void> hideHighlight() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("DOM.hideHighlight", (Map<String, Object>)params.build());
    }

    public static Command<Void> highlightNode() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("DOM.highlightNode", (Map<String, Object>)params.build());
    }

    public static Command<Void> highlightRect() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("DOM.highlightRect", (Map<String, Object>)params.build());
    }

    @Beta
    public static Command<Void> markUndoableState() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("DOM.markUndoableState", (Map<String, Object>)params.build());
    }

    public static Command<NodeId> moveTo(NodeId nodeId, NodeId targetNodeId, Optional<NodeId> insertBeforeNodeId) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        Objects.requireNonNull(targetNodeId, "targetNodeId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"nodeId", (Object)nodeId);
        params.put((Object)"targetNodeId", (Object)targetNodeId);
        insertBeforeNodeId.ifPresent(p -> params.put((Object)"insertBeforeNodeId", p));
        return new Command<NodeId>("DOM.moveTo", (Map<String, Object>)params.build(), ConverterFunctions.map("nodeId", NodeId.class));
    }

    @Beta
    public static Command<PerformSearchResponse> performSearch(String query, Optional<Boolean> includeUserAgentShadowDOM) {
        Objects.requireNonNull(query, "query is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"query", (Object)query);
        includeUserAgentShadowDOM.ifPresent(p -> params.put((Object)"includeUserAgentShadowDOM", p));
        return new Command<PerformSearchResponse>("DOM.performSearch", (Map<String, Object>)params.build(), input -> (PerformSearchResponse)input.read(PerformSearchResponse.class));
    }

    @Beta
    public static Command<NodeId> pushNodeByPathToFrontend(String path) {
        Objects.requireNonNull(path, "path is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"path", (Object)path);
        return new Command<NodeId>("DOM.pushNodeByPathToFrontend", (Map<String, Object>)params.build(), ConverterFunctions.map("nodeId", NodeId.class));
    }

    @Beta
    public static Command<List<NodeId>> pushNodesByBackendIdsToFrontend(List<BackendNodeId> backendNodeIds) {
        Objects.requireNonNull(backendNodeIds, "backendNodeIds is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"backendNodeIds", backendNodeIds);
        return new Command<List<NodeId>>("DOM.pushNodesByBackendIdsToFrontend", (Map<String, Object>)params.build(), ConverterFunctions.map("nodeIds", new TypeToken<List<NodeId>>(){}.getType()));
    }

    public static Command<NodeId> querySelector(NodeId nodeId, String selector) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        Objects.requireNonNull(selector, "selector is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"nodeId", (Object)nodeId);
        params.put((Object)"selector", (Object)selector);
        return new Command<NodeId>("DOM.querySelector", (Map<String, Object>)params.build(), ConverterFunctions.map("nodeId", NodeId.class));
    }

    public static Command<List<NodeId>> querySelectorAll(NodeId nodeId, String selector) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        Objects.requireNonNull(selector, "selector is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"nodeId", (Object)nodeId);
        params.put((Object)"selector", (Object)selector);
        return new Command<List<NodeId>>("DOM.querySelectorAll", (Map<String, Object>)params.build(), ConverterFunctions.map("nodeIds", new TypeToken<List<NodeId>>(){}.getType()));
    }

    @Beta
    public static Command<Void> redo() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("DOM.redo", (Map<String, Object>)params.build());
    }

    public static Command<Void> removeAttribute(NodeId nodeId, String name) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        Objects.requireNonNull(name, "name is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"nodeId", (Object)nodeId);
        params.put((Object)"name", (Object)name);
        return new Command<Void>("DOM.removeAttribute", (Map<String, Object>)params.build());
    }

    public static Command<Void> removeNode(NodeId nodeId) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"nodeId", (Object)nodeId);
        return new Command<Void>("DOM.removeNode", (Map<String, Object>)params.build());
    }

    public static Command<Void> requestChildNodes(NodeId nodeId, Optional<Integer> depth, Optional<Boolean> pierce) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"nodeId", (Object)nodeId);
        depth.ifPresent(p -> params.put((Object)"depth", p));
        pierce.ifPresent(p -> params.put((Object)"pierce", p));
        return new Command<Void>("DOM.requestChildNodes", (Map<String, Object>)params.build());
    }

    public static Command<NodeId> requestNode(RemoteObjectId objectId) {
        Objects.requireNonNull(objectId, "objectId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"objectId", (Object)objectId);
        return new Command<NodeId>("DOM.requestNode", (Map<String, Object>)params.build(), ConverterFunctions.map("nodeId", NodeId.class));
    }

    public static Command<RemoteObject> resolveNode(Optional<NodeId> nodeId, Optional<BackendNodeId> backendNodeId, Optional<String> objectGroup, Optional<ExecutionContextId> executionContextId) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        nodeId.ifPresent(p -> params.put((Object)"nodeId", p));
        backendNodeId.ifPresent(p -> params.put((Object)"backendNodeId", p));
        objectGroup.ifPresent(p -> params.put((Object)"objectGroup", p));
        executionContextId.ifPresent(p -> params.put((Object)"executionContextId", p));
        return new Command<RemoteObject>("DOM.resolveNode", (Map<String, Object>)params.build(), ConverterFunctions.map("object", RemoteObject.class));
    }

    public static Command<Void> setAttributeValue(NodeId nodeId, String name, String value) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        Objects.requireNonNull(name, "name is required");
        Objects.requireNonNull(value, "value is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"nodeId", (Object)nodeId);
        params.put((Object)"name", (Object)name);
        params.put((Object)"value", (Object)value);
        return new Command<Void>("DOM.setAttributeValue", (Map<String, Object>)params.build());
    }

    public static Command<Void> setAttributesAsText(NodeId nodeId, String text, Optional<String> name) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        Objects.requireNonNull(text, "text is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"nodeId", (Object)nodeId);
        params.put((Object)"text", (Object)text);
        name.ifPresent(p -> params.put((Object)"name", p));
        return new Command<Void>("DOM.setAttributesAsText", (Map<String, Object>)params.build());
    }

    public static Command<Void> setFileInputFiles(List<String> files, Optional<NodeId> nodeId, Optional<BackendNodeId> backendNodeId, Optional<RemoteObjectId> objectId) {
        Objects.requireNonNull(files, "files is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"files", files);
        nodeId.ifPresent(p -> params.put((Object)"nodeId", p));
        backendNodeId.ifPresent(p -> params.put((Object)"backendNodeId", p));
        objectId.ifPresent(p -> params.put((Object)"objectId", p));
        return new Command<Void>("DOM.setFileInputFiles", (Map<String, Object>)params.build());
    }

    @Beta
    public static Command<Void> setNodeStackTracesEnabled(Boolean enable) {
        Objects.requireNonNull(enable, "enable is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"enable", (Object)enable);
        return new Command<Void>("DOM.setNodeStackTracesEnabled", (Map<String, Object>)params.build());
    }

    @Beta
    public static Command<StackTrace> getNodeStackTraces(NodeId nodeId) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"nodeId", (Object)nodeId);
        return new Command<StackTrace>("DOM.getNodeStackTraces", (Map<String, Object>)params.build(), ConverterFunctions.map("creation", StackTrace.class));
    }

    @Beta
    public static Command<String> getFileInfo(RemoteObjectId objectId) {
        Objects.requireNonNull(objectId, "objectId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"objectId", (Object)objectId);
        return new Command<String>("DOM.getFileInfo", (Map<String, Object>)params.build(), ConverterFunctions.map("path", String.class));
    }

    @Beta
    public static Command<Void> setInspectedNode(NodeId nodeId) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"nodeId", (Object)nodeId);
        return new Command<Void>("DOM.setInspectedNode", (Map<String, Object>)params.build());
    }

    public static Command<NodeId> setNodeName(NodeId nodeId, String name) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        Objects.requireNonNull(name, "name is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"nodeId", (Object)nodeId);
        params.put((Object)"name", (Object)name);
        return new Command<NodeId>("DOM.setNodeName", (Map<String, Object>)params.build(), ConverterFunctions.map("nodeId", NodeId.class));
    }

    public static Command<Void> setNodeValue(NodeId nodeId, String value) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        Objects.requireNonNull(value, "value is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"nodeId", (Object)nodeId);
        params.put((Object)"value", (Object)value);
        return new Command<Void>("DOM.setNodeValue", (Map<String, Object>)params.build());
    }

    public static Command<Void> setOuterHTML(NodeId nodeId, String outerHTML) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        Objects.requireNonNull(outerHTML, "outerHTML is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"nodeId", (Object)nodeId);
        params.put((Object)"outerHTML", (Object)outerHTML);
        return new Command<Void>("DOM.setOuterHTML", (Map<String, Object>)params.build());
    }

    @Beta
    public static Command<Void> undo() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("DOM.undo", (Map<String, Object>)params.build());
    }

    @Beta
    public static Command<GetFrameOwnerResponse> getFrameOwner(FrameId frameId) {
        Objects.requireNonNull(frameId, "frameId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"frameId", (Object)frameId);
        return new Command<GetFrameOwnerResponse>("DOM.getFrameOwner", (Map<String, Object>)params.build(), input -> (GetFrameOwnerResponse)input.read(GetFrameOwnerResponse.class));
    }

    public static Event<AttributeModified> attributeModified() {
        return new Event<AttributeModified>("DOM.attributeModified", input -> (AttributeModified)input.read(AttributeModified.class));
    }

    public static Event<AttributeRemoved> attributeRemoved() {
        return new Event<AttributeRemoved>("DOM.attributeRemoved", input -> (AttributeRemoved)input.read(AttributeRemoved.class));
    }

    public static Event<CharacterDataModified> characterDataModified() {
        return new Event<CharacterDataModified>("DOM.characterDataModified", input -> (CharacterDataModified)input.read(CharacterDataModified.class));
    }

    public static Event<ChildNodeCountUpdated> childNodeCountUpdated() {
        return new Event<ChildNodeCountUpdated>("DOM.childNodeCountUpdated", input -> (ChildNodeCountUpdated)input.read(ChildNodeCountUpdated.class));
    }

    public static Event<ChildNodeInserted> childNodeInserted() {
        return new Event<ChildNodeInserted>("DOM.childNodeInserted", input -> (ChildNodeInserted)input.read(ChildNodeInserted.class));
    }

    public static Event<ChildNodeRemoved> childNodeRemoved() {
        return new Event<ChildNodeRemoved>("DOM.childNodeRemoved", input -> (ChildNodeRemoved)input.read(ChildNodeRemoved.class));
    }

    public static Event<DistributedNodesUpdated> distributedNodesUpdated() {
        return new Event<DistributedNodesUpdated>("DOM.distributedNodesUpdated", input -> (DistributedNodesUpdated)input.read(DistributedNodesUpdated.class));
    }

    public static Event<Void> documentUpdated() {
        return new Event<Void>("DOM.documentUpdated", input -> null);
    }

    public static Event<List<NodeId>> inlineStyleInvalidated() {
        return new Event<List<NodeId>>("DOM.inlineStyleInvalidated", ConverterFunctions.map("nodeIds", new TypeToken<List<NodeId>>(){}.getType()));
    }

    public static Event<PseudoElementAdded> pseudoElementAdded() {
        return new Event<PseudoElementAdded>("DOM.pseudoElementAdded", input -> (PseudoElementAdded)input.read(PseudoElementAdded.class));
    }

    public static Event<PseudoElementRemoved> pseudoElementRemoved() {
        return new Event<PseudoElementRemoved>("DOM.pseudoElementRemoved", input -> (PseudoElementRemoved)input.read(PseudoElementRemoved.class));
    }

    public static Event<SetChildNodes> setChildNodes() {
        return new Event<SetChildNodes>("DOM.setChildNodes", input -> (SetChildNodes)input.read(SetChildNodes.class));
    }

    public static Event<ShadowRootPopped> shadowRootPopped() {
        return new Event<ShadowRootPopped>("DOM.shadowRootPopped", input -> (ShadowRootPopped)input.read(ShadowRootPopped.class));
    }

    public static Event<ShadowRootPushed> shadowRootPushed() {
        return new Event<ShadowRootPushed>("DOM.shadowRootPushed", input -> (ShadowRootPushed)input.read(ShadowRootPushed.class));
    }

    public static class GetFrameOwnerResponse {
        private final BackendNodeId backendNodeId;
        private final Optional<NodeId> nodeId;

        public GetFrameOwnerResponse(BackendNodeId backendNodeId, Optional<NodeId> nodeId) {
            this.backendNodeId = Objects.requireNonNull(backendNodeId, "backendNodeId is required");
            this.nodeId = nodeId;
        }

        public BackendNodeId getBackendNodeId() {
            return this.backendNodeId;
        }

        public Optional<NodeId> getNodeId() {
            return this.nodeId;
        }

        private static GetFrameOwnerResponse fromJson(JsonInput input) {
            BackendNodeId backendNodeId = null;
            Optional<NodeId> nodeId = Optional.empty();
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "backendNodeId": {
                        backendNodeId = (BackendNodeId)input.read(BackendNodeId.class);
                        continue block8;
                    }
                    case "nodeId": {
                        nodeId = Optional.ofNullable((NodeId)input.read(NodeId.class));
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetFrameOwnerResponse(backendNodeId, nodeId);
        }
    }

    public static class PerformSearchResponse {
        private final String searchId;
        private final Integer resultCount;

        public PerformSearchResponse(String searchId, Integer resultCount) {
            this.searchId = Objects.requireNonNull(searchId, "searchId is required");
            this.resultCount = Objects.requireNonNull(resultCount, "resultCount is required");
        }

        public String getSearchId() {
            return this.searchId;
        }

        public Integer getResultCount() {
            return this.resultCount;
        }

        private static PerformSearchResponse fromJson(JsonInput input) {
            String searchId = null;
            Integer resultCount = null;
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "searchId": {
                        searchId = input.nextString();
                        continue block8;
                    }
                    case "resultCount": {
                        resultCount = input.nextNumber().intValue();
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new PerformSearchResponse(searchId, resultCount);
        }
    }

    public static class GetNodeForLocationResponse {
        private final BackendNodeId backendNodeId;
        private final FrameId frameId;
        private final Optional<NodeId> nodeId;

        public GetNodeForLocationResponse(BackendNodeId backendNodeId, FrameId frameId, Optional<NodeId> nodeId) {
            this.backendNodeId = Objects.requireNonNull(backendNodeId, "backendNodeId is required");
            this.frameId = Objects.requireNonNull(frameId, "frameId is required");
            this.nodeId = nodeId;
        }

        public BackendNodeId getBackendNodeId() {
            return this.backendNodeId;
        }

        public FrameId getFrameId() {
            return this.frameId;
        }

        public Optional<NodeId> getNodeId() {
            return this.nodeId;
        }

        private static GetNodeForLocationResponse fromJson(JsonInput input) {
            BackendNodeId backendNodeId = null;
            FrameId frameId = null;
            Optional<NodeId> nodeId = Optional.empty();
            input.beginObject();
            block10: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "backendNodeId": {
                        backendNodeId = (BackendNodeId)input.read(BackendNodeId.class);
                        continue block10;
                    }
                    case "frameId": {
                        frameId = (FrameId)input.read(FrameId.class);
                        continue block10;
                    }
                    case "nodeId": {
                        nodeId = Optional.ofNullable((NodeId)input.read(NodeId.class));
                        continue block10;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetNodeForLocationResponse(backendNodeId, frameId, nodeId);
        }
    }
}

