/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.network.model;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.network.model.Headers;
import org.openqa.selenium.devtools.network.model.ResourcePriority;
import org.openqa.selenium.devtools.security.model.MixedContentType;
import org.openqa.selenium.json.JsonInput;

public class Request {
    private final String url;
    private final Optional<String> urlFragment;
    private final String method;
    private final Headers headers;
    private final Optional<String> postData;
    private final Optional<Boolean> hasPostData;
    private final Optional<MixedContentType> mixedContentType;
    private final ResourcePriority initialPriority;
    private final ReferrerPolicy referrerPolicy;
    private final Optional<Boolean> isLinkPreload;

    public Request(String url, Optional<String> urlFragment, String method, Headers headers, Optional<String> postData, Optional<Boolean> hasPostData, Optional<MixedContentType> mixedContentType, ResourcePriority initialPriority, ReferrerPolicy referrerPolicy, Optional<Boolean> isLinkPreload) {
        this.url = Objects.requireNonNull(url, "url is required");
        this.urlFragment = urlFragment;
        this.method = Objects.requireNonNull(method, "method is required");
        this.headers = Objects.requireNonNull(headers, "headers is required");
        this.postData = postData;
        this.hasPostData = hasPostData;
        this.mixedContentType = mixedContentType;
        this.initialPriority = Objects.requireNonNull(initialPriority, "initialPriority is required");
        this.referrerPolicy = Objects.requireNonNull(referrerPolicy, "referrerPolicy is required");
        this.isLinkPreload = isLinkPreload;
    }

    public String getUrl() {
        return this.url;
    }

    public Optional<String> getUrlFragment() {
        return this.urlFragment;
    }

    public String getMethod() {
        return this.method;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public Optional<String> getPostData() {
        return this.postData;
    }

    public Optional<Boolean> getHasPostData() {
        return this.hasPostData;
    }

    public Optional<MixedContentType> getMixedContentType() {
        return this.mixedContentType;
    }

    public ResourcePriority getInitialPriority() {
        return this.initialPriority;
    }

    public ReferrerPolicy getReferrerPolicy() {
        return this.referrerPolicy;
    }

    public Optional<Boolean> getIsLinkPreload() {
        return this.isLinkPreload;
    }

    private static Request fromJson(JsonInput input) {
        String url = null;
        Optional<String> urlFragment = Optional.empty();
        String method = null;
        Headers headers = null;
        Optional<String> postData = Optional.empty();
        Optional<Boolean> hasPostData = Optional.empty();
        Optional<MixedContentType> mixedContentType = Optional.empty();
        ResourcePriority initialPriority = null;
        ReferrerPolicy referrerPolicy = null;
        Optional<Boolean> isLinkPreload = Optional.empty();
        input.beginObject();
        block24: while (input.hasNext()) {
            switch (input.nextName()) {
                case "url": {
                    url = input.nextString();
                    continue block24;
                }
                case "urlFragment": {
                    urlFragment = Optional.ofNullable(input.nextString());
                    continue block24;
                }
                case "method": {
                    method = input.nextString();
                    continue block24;
                }
                case "headers": {
                    headers = (Headers)((Object)input.read(Headers.class));
                    continue block24;
                }
                case "postData": {
                    postData = Optional.ofNullable(input.nextString());
                    continue block24;
                }
                case "hasPostData": {
                    hasPostData = Optional.ofNullable(input.nextBoolean());
                    continue block24;
                }
                case "mixedContentType": {
                    mixedContentType = Optional.ofNullable((MixedContentType)((Object)input.read(MixedContentType.class)));
                    continue block24;
                }
                case "initialPriority": {
                    initialPriority = (ResourcePriority)((Object)input.read(ResourcePriority.class));
                    continue block24;
                }
                case "referrerPolicy": {
                    referrerPolicy = ReferrerPolicy.fromString(input.nextString());
                    continue block24;
                }
                case "isLinkPreload": {
                    isLinkPreload = Optional.ofNullable(input.nextBoolean());
                    continue block24;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new Request(url, urlFragment, method, headers, postData, hasPostData, mixedContentType, initialPriority, referrerPolicy, isLinkPreload);
    }

    public static enum ReferrerPolicy {
        UNSAFE_URL("unsafe-url"),
        NO_REFERRER_WHEN_DOWNGRADE("no-referrer-when-downgrade"),
        NO_REFERRER("no-referrer"),
        ORIGIN("origin"),
        ORIGIN_WHEN_CROSS_ORIGIN("origin-when-cross-origin"),
        SAME_ORIGIN("same-origin"),
        STRICT_ORIGIN("strict-origin"),
        STRICT_ORIGIN_WHEN_CROSS_ORIGIN("strict-origin-when-cross-origin");

        private String value;

        private ReferrerPolicy(String value) {
            this.value = value;
        }

        public static ReferrerPolicy fromString(String s) {
            return Arrays.stream(ReferrerPolicy.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within ReferrerPolicy "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static ReferrerPolicy fromJson(JsonInput input) {
            return ReferrerPolicy.fromString(input.nextString());
        }
    }
}

