/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.profiler;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.profiler.model.ConsoleProfileFinished;
import org.openqa.selenium.devtools.profiler.model.ConsoleProfileStarted;
import org.openqa.selenium.devtools.profiler.model.CounterInfo;
import org.openqa.selenium.devtools.profiler.model.PreciseCoverageDeltaUpdate;
import org.openqa.selenium.devtools.profiler.model.Profile;
import org.openqa.selenium.devtools.profiler.model.ScriptCoverage;
import org.openqa.selenium.devtools.profiler.model.ScriptTypeProfile;
import org.openqa.selenium.json.JsonInput;

public class Profiler {
    public static Command<Void> disable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Profiler.disable", (Map<String, Object>)params.build());
    }

    public static Command<Void> enable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Profiler.enable", (Map<String, Object>)params.build());
    }

    public static Command<List<ScriptCoverage>> getBestEffortCoverage() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<List<ScriptCoverage>>("Profiler.getBestEffortCoverage", (Map<String, Object>)params.build(), ConverterFunctions.map("result", new TypeToken<List<ScriptCoverage>>(){}.getType()));
    }

    public static Command<Void> setSamplingInterval(Integer interval) {
        Objects.requireNonNull(interval, "interval is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"interval", (Object)interval);
        return new Command<Void>("Profiler.setSamplingInterval", (Map<String, Object>)params.build());
    }

    public static Command<Void> start() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Profiler.start", (Map<String, Object>)params.build());
    }

    public static Command<Number> startPreciseCoverage(Optional<Boolean> callCount, Optional<Boolean> detailed, Optional<Boolean> allowTriggeredUpdates) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        callCount.ifPresent(p -> params.put((Object)"callCount", p));
        detailed.ifPresent(p -> params.put((Object)"detailed", p));
        allowTriggeredUpdates.ifPresent(p -> params.put((Object)"allowTriggeredUpdates", p));
        return new Command<Number>("Profiler.startPreciseCoverage", (Map<String, Object>)params.build(), ConverterFunctions.map("timestamp", Number.class));
    }

    @Beta
    public static Command<Void> startTypeProfile() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Profiler.startTypeProfile", (Map<String, Object>)params.build());
    }

    public static Command<Profile> stop() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Profile>("Profiler.stop", (Map<String, Object>)params.build(), ConverterFunctions.map("profile", Profile.class));
    }

    public static Command<Void> stopPreciseCoverage() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Profiler.stopPreciseCoverage", (Map<String, Object>)params.build());
    }

    @Beta
    public static Command<Void> stopTypeProfile() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Profiler.stopTypeProfile", (Map<String, Object>)params.build());
    }

    public static Command<TakePreciseCoverageResponse> takePreciseCoverage() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<TakePreciseCoverageResponse>("Profiler.takePreciseCoverage", (Map<String, Object>)params.build(), input -> (TakePreciseCoverageResponse)input.read(TakePreciseCoverageResponse.class));
    }

    @Beta
    public static Command<List<ScriptTypeProfile>> takeTypeProfile() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<List<ScriptTypeProfile>>("Profiler.takeTypeProfile", (Map<String, Object>)params.build(), ConverterFunctions.map("result", new TypeToken<List<ScriptTypeProfile>>(){}.getType()));
    }

    @Beta
    public static Command<Void> enableRuntimeCallStats() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Profiler.enableRuntimeCallStats", (Map<String, Object>)params.build());
    }

    @Beta
    public static Command<Void> disableRuntimeCallStats() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Profiler.disableRuntimeCallStats", (Map<String, Object>)params.build());
    }

    @Beta
    public static Command<List<CounterInfo>> getRuntimeCallStats() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<List<CounterInfo>>("Profiler.getRuntimeCallStats", (Map<String, Object>)params.build(), ConverterFunctions.map("result", new TypeToken<List<CounterInfo>>(){}.getType()));
    }

    public static Event<ConsoleProfileFinished> consoleProfileFinished() {
        return new Event<ConsoleProfileFinished>("Profiler.consoleProfileFinished", input -> (ConsoleProfileFinished)input.read(ConsoleProfileFinished.class));
    }

    public static Event<ConsoleProfileStarted> consoleProfileStarted() {
        return new Event<ConsoleProfileStarted>("Profiler.consoleProfileStarted", input -> (ConsoleProfileStarted)input.read(ConsoleProfileStarted.class));
    }

    public static Event<PreciseCoverageDeltaUpdate> preciseCoverageDeltaUpdate() {
        return new Event<PreciseCoverageDeltaUpdate>("Profiler.preciseCoverageDeltaUpdate", input -> (PreciseCoverageDeltaUpdate)input.read(PreciseCoverageDeltaUpdate.class));
    }

    public static class TakePreciseCoverageResponse {
        private final List<ScriptCoverage> result;
        private final Number timestamp;

        public TakePreciseCoverageResponse(List<ScriptCoverage> result, Number timestamp) {
            this.result = Objects.requireNonNull(result, "result is required");
            this.timestamp = Objects.requireNonNull(timestamp, "timestamp is required");
        }

        public List<ScriptCoverage> getResult() {
            return this.result;
        }

        public Number getTimestamp() {
            return this.timestamp;
        }

        private static TakePreciseCoverageResponse fromJson(JsonInput input) {
            List result = null;
            Number timestamp = null;
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "result": {
                        result = (List)input.read(new TypeToken<List<ScriptCoverage>>(){}.getType());
                        continue block8;
                    }
                    case "timestamp": {
                        timestamp = input.nextNumber();
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new TakePreciseCoverageResponse(result, timestamp);
        }
    }
}

