/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.target;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.browser.model.BrowserContextID;
import org.openqa.selenium.devtools.target.model.AttachedToTarget;
import org.openqa.selenium.devtools.target.model.DetachedFromTarget;
import org.openqa.selenium.devtools.target.model.ReceivedMessageFromTarget;
import org.openqa.selenium.devtools.target.model.RemoteLocation;
import org.openqa.selenium.devtools.target.model.SessionID;
import org.openqa.selenium.devtools.target.model.TargetCrashed;
import org.openqa.selenium.devtools.target.model.TargetID;
import org.openqa.selenium.devtools.target.model.TargetInfo;

public class Target {
    public static Command<Void> activateTarget(TargetID targetId) {
        Objects.requireNonNull(targetId, "targetId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"targetId", (Object)targetId);
        return new Command<Void>("Target.activateTarget", (Map<String, Object>)params.build());
    }

    public static Command<SessionID> attachToTarget(TargetID targetId, Optional<Boolean> flatten) {
        Objects.requireNonNull(targetId, "targetId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"targetId", (Object)targetId);
        flatten.ifPresent(p -> params.put((Object)"flatten", p));
        return new Command<SessionID>("Target.attachToTarget", (Map<String, Object>)params.build(), ConverterFunctions.map("sessionId", SessionID.class));
    }

    @Beta
    public static Command<SessionID> attachToBrowserTarget() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<SessionID>("Target.attachToBrowserTarget", (Map<String, Object>)params.build(), ConverterFunctions.map("sessionId", SessionID.class));
    }

    public static Command<Boolean> closeTarget(TargetID targetId) {
        Objects.requireNonNull(targetId, "targetId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"targetId", (Object)targetId);
        return new Command<Boolean>("Target.closeTarget", (Map<String, Object>)params.build(), ConverterFunctions.map("success", Boolean.class));
    }

    @Beta
    public static Command<Void> exposeDevToolsProtocol(TargetID targetId, Optional<String> bindingName) {
        Objects.requireNonNull(targetId, "targetId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"targetId", (Object)targetId);
        bindingName.ifPresent(p -> params.put((Object)"bindingName", p));
        return new Command<Void>("Target.exposeDevToolsProtocol", (Map<String, Object>)params.build());
    }

    @Beta
    public static Command<BrowserContextID> createBrowserContext(Optional<Boolean> disposeOnDetach) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        disposeOnDetach.ifPresent(p -> params.put((Object)"disposeOnDetach", p));
        return new Command<BrowserContextID>("Target.createBrowserContext", (Map<String, Object>)params.build(), ConverterFunctions.map("browserContextId", BrowserContextID.class));
    }

    @Beta
    public static Command<List<BrowserContextID>> getBrowserContexts() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<List<BrowserContextID>>("Target.getBrowserContexts", (Map<String, Object>)params.build(), ConverterFunctions.map("browserContextIds", new TypeToken<List<BrowserContextID>>(){}.getType()));
    }

    public static Command<TargetID> createTarget(String url, Optional<Integer> width, Optional<Integer> height, Optional<BrowserContextID> browserContextId, Optional<Boolean> enableBeginFrameControl, Optional<Boolean> newWindow, Optional<Boolean> background) {
        Objects.requireNonNull(url, "url is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"url", (Object)url);
        width.ifPresent(p -> params.put((Object)"width", p));
        height.ifPresent(p -> params.put((Object)"height", p));
        browserContextId.ifPresent(p -> params.put((Object)"browserContextId", p));
        enableBeginFrameControl.ifPresent(p -> params.put((Object)"enableBeginFrameControl", p));
        newWindow.ifPresent(p -> params.put((Object)"newWindow", p));
        background.ifPresent(p -> params.put((Object)"background", p));
        return new Command<TargetID>("Target.createTarget", (Map<String, Object>)params.build(), ConverterFunctions.map("targetId", TargetID.class));
    }

    public static Command<Void> detachFromTarget(Optional<SessionID> sessionId, Optional<TargetID> targetId) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        sessionId.ifPresent(p -> params.put((Object)"sessionId", p));
        targetId.ifPresent(p -> params.put((Object)"targetId", p));
        return new Command<Void>("Target.detachFromTarget", (Map<String, Object>)params.build());
    }

    @Beta
    public static Command<Void> disposeBrowserContext(BrowserContextID browserContextId) {
        Objects.requireNonNull(browserContextId, "browserContextId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"browserContextId", (Object)browserContextId);
        return new Command<Void>("Target.disposeBrowserContext", (Map<String, Object>)params.build());
    }

    @Beta
    public static Command<TargetInfo> getTargetInfo(Optional<TargetID> targetId) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        targetId.ifPresent(p -> params.put((Object)"targetId", p));
        return new Command<TargetInfo>("Target.getTargetInfo", (Map<String, Object>)params.build(), ConverterFunctions.map("targetInfo", TargetInfo.class));
    }

    public static Command<List<TargetInfo>> getTargets() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<List<TargetInfo>>("Target.getTargets", (Map<String, Object>)params.build(), ConverterFunctions.map("targetInfos", new TypeToken<List<TargetInfo>>(){}.getType()));
    }

    @Deprecated
    public static Command<Void> sendMessageToTarget(String message, Optional<SessionID> sessionId, Optional<TargetID> targetId) {
        Objects.requireNonNull(message, "message is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"message", (Object)message);
        sessionId.ifPresent(p -> params.put((Object)"sessionId", p));
        targetId.ifPresent(p -> params.put((Object)"targetId", p));
        return new Command<Void>("Target.sendMessageToTarget", (Map<String, Object>)params.build());
    }

    @Beta
    public static Command<Void> setAutoAttach(Boolean autoAttach, Boolean waitForDebuggerOnStart, Optional<Boolean> flatten) {
        Objects.requireNonNull(autoAttach, "autoAttach is required");
        Objects.requireNonNull(waitForDebuggerOnStart, "waitForDebuggerOnStart is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"autoAttach", (Object)autoAttach);
        params.put((Object)"waitForDebuggerOnStart", (Object)waitForDebuggerOnStart);
        flatten.ifPresent(p -> params.put((Object)"flatten", p));
        return new Command<Void>("Target.setAutoAttach", (Map<String, Object>)params.build());
    }

    public static Command<Void> setDiscoverTargets(Boolean discover) {
        Objects.requireNonNull(discover, "discover is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"discover", (Object)discover);
        return new Command<Void>("Target.setDiscoverTargets", (Map<String, Object>)params.build());
    }

    @Beta
    public static Command<Void> setRemoteLocations(List<RemoteLocation> locations) {
        Objects.requireNonNull(locations, "locations is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"locations", locations);
        return new Command<Void>("Target.setRemoteLocations", (Map<String, Object>)params.build());
    }

    public static Event<AttachedToTarget> attachedToTarget() {
        return new Event<AttachedToTarget>("Target.attachedToTarget", input -> (AttachedToTarget)input.read(AttachedToTarget.class));
    }

    public static Event<DetachedFromTarget> detachedFromTarget() {
        return new Event<DetachedFromTarget>("Target.detachedFromTarget", input -> (DetachedFromTarget)input.read(DetachedFromTarget.class));
    }

    public static Event<ReceivedMessageFromTarget> receivedMessageFromTarget() {
        return new Event<ReceivedMessageFromTarget>("Target.receivedMessageFromTarget", input -> (ReceivedMessageFromTarget)input.read(ReceivedMessageFromTarget.class));
    }

    public static Event<TargetInfo> targetCreated() {
        return new Event<TargetInfo>("Target.targetCreated", ConverterFunctions.map("targetInfo", TargetInfo.class));
    }

    public static Event<TargetID> targetDestroyed() {
        return new Event<TargetID>("Target.targetDestroyed", ConverterFunctions.map("targetId", TargetID.class));
    }

    public static Event<TargetCrashed> targetCrashed() {
        return new Event<TargetCrashed>("Target.targetCrashed", input -> (TargetCrashed)input.read(TargetCrashed.class));
    }

    public static Event<TargetInfo> targetInfoChanged() {
        return new Event<TargetInfo>("Target.targetInfoChanged", ConverterFunctions.map("targetInfo", TargetInfo.class));
    }
}

