/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox.internal;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.Command;
import org.openqa.selenium.firefox.ExtensionConnection;
import org.openqa.selenium.firefox.NotConnectedException;
import org.openqa.selenium.firefox.Response;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExtensionConnection
implements ExtensionConnection {
    private Socket socket;
    private Set<SocketAddress> addresses;
    private OutputStreamWriter out;
    private BufferedInputStream in;

    protected void setAddress(String host, int port) {
        if ("localhost".equals(host)) {
            this.addresses = this.obtainLoopbackAddresses(port);
        } else {
            try {
                InetSocketAddress hostAddress = new InetSocketAddress(InetAddress.getByName(host), port);
                this.addresses = Collections.singleton(hostAddress);
            }
            catch (UnknownHostException e) {
                throw new WebDriverException((Throwable)e);
            }
        }
    }

    private Set<SocketAddress> obtainLoopbackAddresses(int port) {
        NetworkInterface firstInterface;
        HashSet<SocketAddress> localhosts = new HashSet<SocketAddress>();
        try {
            NetworkInterface linuxLoopback;
            InetSocketAddress socketAddress;
            Enumeration<NetworkInterface> allInterfaces = NetworkInterface.getNetworkInterfaces();
            while (allInterfaces.hasMoreElements()) {
                NetworkInterface iface = allInterfaces.nextElement();
                Enumeration<InetAddress> allAddresses = iface.getInetAddresses();
                while (allAddresses.hasMoreElements()) {
                    InetAddress addr = allAddresses.nextElement();
                    if (!addr.isLoopbackAddress()) continue;
                    socketAddress = new InetSocketAddress(addr, port);
                    localhosts.add(socketAddress);
                }
            }
            if (Platform.getCurrent().is(Platform.UNIX) && (linuxLoopback = NetworkInterface.getByName("lo")) != null) {
                Enumeration<InetAddress> possibleLoopbacks = linuxLoopback.getInetAddresses();
                while (possibleLoopbacks.hasMoreElements()) {
                    InetAddress inetAddress = possibleLoopbacks.nextElement();
                    socketAddress = new InetSocketAddress(inetAddress, port);
                    localhosts.add(socketAddress);
                }
            }
        }
        catch (SocketException e) {
            throw new WebDriverException((Throwable)e);
        }
        if (!localhosts.isEmpty()) {
            return localhosts;
        }
        try {
            firstInterface = NetworkInterface.getNetworkInterfaces().nextElement();
        }
        catch (SocketException e) {
            throw new WebDriverException((Throwable)e);
        }
        InetAddress firstAddress = null;
        if (firstInterface != null) {
            firstAddress = firstInterface.getInetAddresses().nextElement();
        }
        if (firstAddress != null) {
            InetSocketAddress socketAddress = new InetSocketAddress(firstAddress, port);
            return Collections.singleton(socketAddress);
        }
        throw new WebDriverException("Unable to find loopback address for localhost");
    }

    protected void connectToBrowser(long timeToWaitInMilliSeconds) throws IOException {
        long waitUntil = System.currentTimeMillis() + timeToWaitInMilliSeconds;
        block4: while (!this.isConnected() && waitUntil > System.currentTimeMillis()) {
            for (SocketAddress addr : this.addresses) {
                try {
                    this.connect(addr);
                    continue block4;
                }
                catch (ConnectException e) {
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException ie) {
                        throw new WebDriverException((Throwable)ie);
                    }
                }
            }
        }
        if (!this.isConnected()) {
            throw new NotConnectedException(this.socket, timeToWaitInMilliSeconds);
        }
    }

    private void connect(SocketAddress addr) throws IOException {
        this.socket = new Socket();
        this.socket.connect(addr);
        this.in = new BufferedInputStream(this.socket.getInputStream());
        this.out = new OutputStreamWriter(this.socket.getOutputStream(), "UTF-8");
    }

    @Override
    public boolean isConnected() {
        return this.socket != null && this.socket.isConnected();
    }

    @Override
    public Response sendMessageAndWaitForResponse(Class<? extends RuntimeException> throwOnFailure, Command command) {
        this.sendMessage(command);
        return this.waitForResponseFor(command.getCommandName());
    }

    protected void sendMessage(Command command) {
        String converted = this.convert(command);
        StringBuilder message = new StringBuilder();
        message.append("GET / HTTP/1.1\n");
        message.append("Host: localhost\n");
        message.append("Content-Length: ");
        message.append(converted.length()).append("\n\n");
        message.append(converted).append("\n");
        try {
            this.out.write(message.toString());
            this.out.flush();
        }
        catch (IOException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    private String convert(Command command) {
        JSONObject json = new JSONObject();
        try {
            json.put("commandName", (Object)command.getCommandName());
            json.put("context", (Object)String.valueOf(command.getContext()));
            json.put("elementId", (Object)command.getElementId());
            JSONArray params = new JSONArray();
            for (Object o : command.getParameters()) {
                params.put(o);
            }
            json.put("parameters", (Object)params);
        }
        catch (JSONException e) {
            throw new WebDriverException((Throwable)e);
        }
        try {
            byte[] bytes = json.toString().getBytes("UTF-8");
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Cannot convert string to UTF-8");
        }
    }

    private Response waitForResponseFor(String command) {
        try {
            return this.readLoop(command);
        }
        catch (IOException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    private Response readLoop(String command) throws IOException {
        Response response = this.nextResponse();
        if (command.equals(response.getCommand())) {
            return response;
        }
        throw new WebDriverException("Expected response to " + command + " but actually got: " + response.getCommand() + " (" + response.getCommand() + ")");
    }

    private Response nextResponse() throws IOException {
        String line = this.readLine();
        int count = 0;
        String[] parts = line.split(":", 2);
        if ("Length".equals(parts[0])) {
            count = Integer.parseInt(parts[1].trim());
        }
        while (line.length() != 0) {
            line = this.readLine();
        }
        byte[] remaining = new byte[count];
        for (int i = 0; i < count; ++i) {
            remaining[i] = (byte)this.in.read();
        }
        return new Response(new String(remaining, "UTF-8"));
    }

    private String readLine() throws IOException {
        int b;
        int size = 4096;
        int growBy = 1024;
        byte[] raw = new byte[size];
        int count = 0;
        while ((b = this.in.read()) != -1 && (char)b != '\n') {
            raw[count++] = (byte)b;
            if (count != size) continue;
            byte[] temp = new byte[size += growBy];
            System.arraycopy(raw, 0, temp, 0, count);
            raw = temp;
        }
        return new String(raw, 0, count, "UTF-8");
    }
}

