/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.internal.Executable;
import org.openqa.selenium.net.PortProber;
import org.openqa.selenium.remote.service.DriverService;

public class GeckoDriverService
extends DriverService {
    public static final String GECKO_DRIVER_EXE_PROPERTY = "webdriver.gecko.driver";

    public GeckoDriverService(File executable, int port, ImmutableList<String> args, ImmutableMap<String, String> environment) throws IOException {
        super(executable, port, args, environment);
    }

    public static GeckoDriverService createDefaultService() {
        return (GeckoDriverService)((Builder)new Builder().usingAnyFreePort()).build();
    }

    protected void waitUntilAvailable() throws MalformedURLException {
        PortProber.waitForPortUp((int)this.getUrl().getPort(), (int)20, (TimeUnit)TimeUnit.SECONDS);
    }

    public static class Builder
    extends DriverService.Builder<GeckoDriverService, Builder> {
        protected File findDefaultExecutable() {
            try {
                return GeckoDriverService.findExecutable((String)"geckodriver", (String)GeckoDriverService.GECKO_DRIVER_EXE_PROPERTY, (String)"https://github.com/mozilla/geckodriver", (String)"https://github.com/mozilla/geckodriver/releases");
            }
            catch (IllegalStateException e) {
                return GeckoDriverService.findExecutable((String)"wires", (String)GeckoDriverService.GECKO_DRIVER_EXE_PROPERTY, (String)"https://github.com/mozilla/geckodriver", (String)"https://github.com/mozilla/geckodriver/releases");
            }
        }

        protected ImmutableList<String> createArgs() {
            ImmutableList.Builder argsBuilder = ImmutableList.builder();
            argsBuilder.add((Object)String.format("--port=%d", this.getPort()));
            if (this.getLogFile() != null) {
                argsBuilder.add((Object)String.format("--log-file=\"%s\"", this.getLogFile().getAbsolutePath()));
            }
            argsBuilder.add((Object)"-b");
            argsBuilder.add((Object)new Executable(null).getPath());
            return argsBuilder.build();
        }

        protected GeckoDriverService createDriverService(File exe, int port, ImmutableList<String> args, ImmutableMap<String, String> environment) {
            try {
                return new GeckoDriverService(exe, port, args, environment);
            }
            catch (IOException e) {
                throw new WebDriverException((Throwable)e);
            }
        }
    }
}

