/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.Executable;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.os.ExecutableFinder;

public class FirefoxBinary {
    private final List<String> extraOptions = new ArrayList<String>();
    private final Executable executable;
    private long timeout = TimeUnit.SECONDS.toMillis(45L);

    public FirefoxBinary() {
        Executable systemBinary = FirefoxBinary.locateFirefoxBinaryFromSystemProperty();
        if (systemBinary != null) {
            this.executable = systemBinary;
            return;
        }
        Executable platformBinary = FirefoxBinary.locateFirefoxBinariesFromPlatform().findFirst().orElse(null);
        if (platformBinary != null) {
            this.executable = platformBinary;
            return;
        }
        throw new WebDriverException("Cannot find firefox binary in PATH. Make sure firefox is installed. OS appears to be: " + Platform.getCurrent());
    }

    public FirefoxBinary(Channel channel) {
        Executable systemBinary = FirefoxBinary.locateFirefoxBinaryFromSystemProperty();
        if (systemBinary != null) {
            if (systemBinary.getChannel() == channel) {
                this.executable = systemBinary;
                return;
            }
            throw new WebDriverException("Firefox executable specified by system property webdriver.firefox.bin does not belong to channel '" + (Object)((Object)channel) + "', it appears to be '" + (Object)((Object)systemBinary.getChannel()) + "'");
        }
        this.executable = FirefoxBinary.locateFirefoxBinariesFromPlatform().filter(e -> e.getChannel() == channel).findFirst().orElseThrow(() -> new WebDriverException(String.format("Cannot find firefox binary for channel '%s' in PATH", new Object[]{channel})));
    }

    public FirefoxBinary(File pathToFirefoxBinary) {
        this.executable = new Executable(pathToFirefoxBinary);
    }

    public void addCommandLineOptions(String ... options) {
        Collections.addAll(this.extraOptions, options);
    }

    void amendOptions(FirefoxOptions options) {
        options.addArguments(this.extraOptions);
    }

    public File getFile() {
        return this.executable.getFile();
    }

    public String getPath() {
        return this.executable.getPath();
    }

    public List<String> getExtraOptions() {
        return this.extraOptions;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public String toString() {
        return "FirefoxBinary(" + this.executable.getPath() + ")";
    }

    public String toJson() {
        return this.executable.getPath();
    }

    private static Executable locateFirefoxBinaryFromSystemProperty() {
        String binaryName = System.getProperty("webdriver.firefox.bin");
        if (binaryName == null) {
            return null;
        }
        File binary = new File(binaryName);
        if (binary.exists() && !binary.isDirectory()) {
            return new Executable(binary);
        }
        Platform current = Platform.getCurrent();
        if (current.is(Platform.WINDOWS)) {
            if (!binaryName.endsWith(".exe")) {
                binaryName = binaryName + ".exe";
            }
        } else if (current.is(Platform.MAC)) {
            if (!binaryName.endsWith(".app")) {
                binaryName = binaryName + ".app";
            }
            binaryName = binaryName + "/Contents/MacOS/firefox-bin";
        }
        if ((binary = new File(binaryName)).exists()) {
            return new Executable(binary);
        }
        throw new WebDriverException(String.format("'%s' property set, but unable to locate the requested binary: %s", "webdriver.firefox.bin", binaryName));
    }

    private static Stream<Executable> locateFirefoxBinariesFromPlatform() {
        String systemFirefoxBin;
        ImmutableList.Builder executables = new ImmutableList.Builder();
        Platform current = Platform.getCurrent();
        if (current.is(Platform.WINDOWS)) {
            executables.addAll((Iterable)Stream.of("Mozilla Firefox\\firefox.exe", "Firefox Developer Edition\\firefox.exe", "Nightly\\firefox.exe").map(FirefoxBinary::getPathsInProgramFiles).flatMap(Collection::stream).map(File::new).filter(File::exists).map(Executable::new).collect(Collectors.toList()));
        } else if (current.is(Platform.MAC)) {
            File binary = new File("/Applications/Firefox.app/Contents/MacOS/firefox-bin");
            if (binary.exists()) {
                executables.add((Object)new Executable(binary));
            }
            if ((binary = new File(System.getProperty("user.home") + binary.getAbsolutePath())).exists()) {
                executables.add((Object)new Executable(binary));
            }
        } else if (current.is(Platform.UNIX) && (systemFirefoxBin = new ExecutableFinder().find("firefox-bin")) != null) {
            executables.add((Object)new Executable(new File(systemFirefoxBin)));
        }
        String systemFirefox = new ExecutableFinder().find("firefox");
        if (systemFirefox != null) {
            Path firefoxPath = new File(systemFirefox).toPath();
            if (Files.isSymbolicLink(firefoxPath)) {
                try {
                    Path realPath = firefoxPath.toRealPath(new LinkOption[0]);
                    File attempt1 = realPath.getParent().resolve("firefox").toFile();
                    if (attempt1.exists()) {
                        executables.add((Object)new Executable(attempt1));
                    } else {
                        File attempt2 = realPath.getParent().resolve("firefox-bin").toFile();
                        if (attempt2.exists()) {
                            executables.add((Object)new Executable(attempt2));
                        }
                    }
                }
                catch (IOException iOException) {}
            } else {
                executables.add((Object)new Executable(new File(systemFirefox)));
            }
        }
        return executables.build().stream();
    }

    private static List<String> getPathsInProgramFiles(String childPath) {
        return Stream.of(FirefoxBinary.getProgramFilesPath(), FirefoxBinary.getProgramFiles86Path()).map(parent -> new File((String)parent, childPath).getAbsolutePath()).collect(Collectors.toList());
    }

    private static String getProgramFilesPath() {
        return FirefoxBinary.getEnvVarPath("ProgramFiles", "C:\\Program Files").replace(" (x86)", "");
    }

    private static String getProgramFiles86Path() {
        return FirefoxBinary.getEnvVarPath("ProgramFiles(x86)", "C:\\Program Files (x86)");
    }

    private static String getEnvVarPath(String envVar, String defaultValue) {
        return FirefoxBinary.getEnvVarIgnoreCase(envVar).map(File::new).filter(File::exists).map(File::getAbsolutePath).orElseGet(() -> new File(defaultValue).getAbsolutePath());
    }

    private static Optional<String> getEnvVarIgnoreCase(String var) {
        return System.getenv().entrySet().stream().filter(e -> ((String)e.getKey()).equalsIgnoreCase(var)).findFirst().map(Map.Entry::getValue);
    }

    public static enum Channel {
        ESR("esr"),
        RELEASE("release"),
        BETA("beta"),
        AURORA("aurora"),
        NIGHTLY("nightly");

        private String name;

        private Channel(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static Channel fromString(String name) {
            String lcName = name.toLowerCase();
            return Arrays.stream(Channel.values()).filter(ch -> ch.name.equals(lcName)).findFirst().orElseThrow(() -> new WebDriverException("Unrecognized channel: " + name));
        }
    }
}

