/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import com.google.auto.service.AutoService;
import java.util.Optional;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebDriverInfo;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.GeckoDriverService;

@AutoService(value={WebDriverInfo.class})
public class GeckoDriverInfo
implements WebDriverInfo {
    public String getDisplayName() {
        return "Firefox";
    }

    public Capabilities getCanonicalCapabilities() {
        return new ImmutableCapabilities("browserName", (Object)"firefox");
    }

    public boolean isSupporting(Capabilities capabilities) {
        if (capabilities.is("marionette")) {
            return false;
        }
        if ("firefox".equals(capabilities.getBrowserName())) {
            return true;
        }
        return capabilities.asMap().keySet().stream().map(key -> key.startsWith("moz:")).reduce(Boolean::logicalOr).orElse(false);
    }

    public boolean isSupportingCdp() {
        return false;
    }

    public boolean isAvailable() {
        try {
            GeckoDriverService.createDefaultService();
            return true;
        }
        catch (IllegalStateException | WebDriverException e) {
            return false;
        }
    }

    public int getMaximumSimultaneousSessions() {
        return Runtime.getRuntime().availableProcessors() + 1;
    }

    public Optional<WebDriver> createDriver(Capabilities capabilities) throws SessionNotCreatedException {
        if (!this.isAvailable()) {
            return Optional.empty();
        }
        if (capabilities.is("marionette")) {
            return Optional.empty();
        }
        return Optional.of(new FirefoxDriver(capabilities));
    }
}

