/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.function.Predicate;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WrapsDriver;
import org.openqa.selenium.firefox.HasExtensions;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.io.Zip;
import org.openqa.selenium.remote.AdditionalHttpCommands;
import org.openqa.selenium.remote.AugmenterProvider;
import org.openqa.selenium.remote.Browser;
import org.openqa.selenium.remote.CommandInfo;
import org.openqa.selenium.remote.ExecuteMethod;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.http.HttpMethod;

@AutoService(value={AdditionalHttpCommands.class, AugmenterProvider.class})
public class AddHasExtensions
implements AugmenterProvider<HasExtensions>,
AdditionalHttpCommands {
    public static final String INSTALL_EXTENSION = "installExtension";
    public static final String UNINSTALL_EXTENSION = "uninstallExtension";
    private static final Map<String, CommandInfo> COMMANDS = ImmutableMap.of((Object)"installExtension", (Object)new CommandInfo("/session/:sessionId/moz/addon/install", HttpMethod.POST), (Object)"uninstallExtension", (Object)new CommandInfo("/session/:sessionId/moz/addon/uninstall", HttpMethod.POST));

    public Map<String, CommandInfo> getAdditionalCommands() {
        return COMMANDS;
    }

    public Predicate<Capabilities> isApplicable() {
        return arg_0 -> ((Browser)Browser.FIREFOX).is(arg_0);
    }

    public Class<HasExtensions> getDescribedInterface() {
        return HasExtensions.class;
    }

    public HasExtensions getImplementation(Capabilities capabilities, final ExecuteMethod executeMethod) {
        return new HasExtensions(){

            @Override
            public String installExtension(Path path) {
                File localFile;
                WebDriver wrapped;
                Require.nonNull((String)"Extension Path", (Object)path);
                if (executeMethod instanceof WrapsDriver && (wrapped = ((WrapsDriver)executeMethod).getWrappedDriver()) instanceof RemoteWebDriver && (localFile = ((RemoteWebDriver)wrapped).getFileDetector().getLocalFile(new CharSequence[]{path.toString()})) != null) {
                    try {
                        String zip = Zip.zip((File)localFile);
                        String newPath = (String)executeMethod.execute("uploadFile", (Map)ImmutableMap.of((Object)"file", (Object)zip));
                        return this.installExtensionAtPath(newPath);
                    }
                    catch (IOException e) {
                        throw new WebDriverException("Cannot upload " + localFile, (Throwable)e);
                    }
                }
                return this.installExtensionAtPath(path.toString());
            }

            @Override
            public void uninstallExtension(String extensionId) {
                Require.nonNull((String)"Extension ID", (Object)extensionId);
                executeMethod.execute(AddHasExtensions.UNINSTALL_EXTENSION, (Map)ImmutableMap.of((Object)"id", (Object)extensionId));
            }

            private String installExtensionAtPath(String path) {
                return (String)executeMethod.execute(AddHasExtensions.INSTALL_EXTENSION, (Map)ImmutableMap.of((Object)"path", (Object)path, (Object)"temporary", (Object)false));
            }
        };
    }
}

