/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi;

import com.google.common.collect.ImmutableMap;
import java.io.Closeable;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import org.openqa.selenium.bidi.BiDiSessionStatus;
import org.openqa.selenium.bidi.Command;
import org.openqa.selenium.bidi.Connection;
import org.openqa.selenium.bidi.Event;
import org.openqa.selenium.internal.Require;

public class BiDi
implements Closeable {
    private final Duration timeout = Duration.ofSeconds(30L);
    private final Connection connection;
    private final BiDiSessionStatus status;

    public BiDi(Connection connection) {
        this.connection = (Connection)Require.nonNull((String)"WebSocket connection", (Object)connection);
        this.status = (BiDiSessionStatus)this.send(new Command("session.status", Collections.emptyMap(), (Type)((Object)BiDiSessionStatus.class)));
    }

    @Override
    public void close() {
        this.clearListeners();
        this.disconnectSession();
    }

    public void disconnectSession() {
    }

    public <X> X send(Command<X> command) {
        Require.nonNull((String)"Command to send", command);
        return this.connection.sendAndWait(command, this.timeout);
    }

    public <X> void addListener(Event<X> event, Consumer<X> handler) {
        Require.nonNull((String)"Event to listen for", event);
        Require.nonNull((String)"Handler to call", handler);
        this.send(new Command("session.subscribe", (Map<String, Object>)ImmutableMap.of((Object)"events", Collections.singletonList(event.getMethod()))));
        this.connection.addListener(event, handler);
    }

    public void clearListeners() {
        this.send(new Command("session.unsubscribe", Collections.emptyMap()));
        this.connection.clearListeners();
    }

    public BiDiSessionStatus getBidiSessionStatus() {
        return this.status;
    }
}

