/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.config;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import org.openqa.selenium.grid.config.ClassCreation;
import org.openqa.selenium.json.Json;

public interface Config {
    public Set<String> getSectionNames();

    public Set<String> getOptions(String var1);

    public Optional<List<String>> getAll(String var1, String var2);

    default public Optional<String> get(String section, String option) {
        return this.getAll(section, option).map(items -> items.isEmpty() ? null : (String)items.get(0));
    }

    default public Optional<Integer> getInt(String section, String option) {
        return this.get(section, option).map(Integer::parseInt);
    }

    default public Optional<Boolean> getBool(String section, String option) {
        return this.get(section, option).map(Boolean::parseBoolean);
    }

    default public <X> X getClass(String section, String option, Class<X> typeOfClass, String defaultClazz) {
        String clazz = this.get(section, option).orElse(defaultClazz);
        Logger.getLogger(Config.class.getName()).fine(String.format("Creating %s as instance of %s", clazz, typeOfClass));
        try {
            return ClassCreation.callCreateMethod(clazz, typeOfClass, this);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException("Unable to find class: " + clazz, e);
        }
    }

    default public List<String> toEntryList(Map<String, Object> mapItem) {
        return (List)mapItem.entrySet().stream().map(entry -> String.format("%s=%s", entry.getKey(), this.toJson(entry.getValue()))).sorted().collect(ImmutableList.toImmutableList());
    }

    default public String toJson(Object value) {
        StringBuilder jsonStr = new StringBuilder();
        new Json().newOutput((Appendable)jsonStr).setPrettyPrint(false).write(value);
        return jsonStr.toString();
    }
}

