/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.node.relay;

import com.beust.jcommander.Parameter;
import com.google.auto.service.AutoService;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.openqa.selenium.grid.config.ConfigValue;
import org.openqa.selenium.grid.config.HasRoles;
import org.openqa.selenium.grid.config.NonSplittingSplitter;
import org.openqa.selenium.grid.config.Role;
import org.openqa.selenium.grid.config.StandardGridRoles;

@AutoService(value={HasRoles.class})
public class RelayFlags
implements HasRoles {
    @Parameter(names={"--service-configuration"}, description="Configuration for the service where calls will be relayed to. It is recommended to provide this type of configuration through a toml config file to improve readability. Command line example: --service-configuration max-sessions=2 stereotype='{\"browserName\": \"safari\", \"platformName\": \"iOS\", \"appium:platformVersion\": \"14.5\"}}'", arity=4, variableArity=true, splitter=NonSplittingSplitter.class)
    @ConfigValue(section="relay", name="configs", prefixed=true, example={"\nmax-sessions = 2\nstereotype = \"{\\\"browserName\\\": \\\"safari\\\", \\\"platformName\\\": \\\"iOS\\\", \\\"appium:platformVersion\\\": \\\"14.5\\\" }}\""})
    public List<String> driverConfiguration;
    @Parameter(names={"--service-url"}, description="URL for connecting to the service that supports WebDriver commands, like an Appium server or a cloud service.")
    @ConfigValue(section="relay", name="url", example={"\"http://localhost:4723\""})
    private String serviceUrl;
    @Parameter(names={"--service-host"}, description="Host name where the service that supports WebDriver commands is running")
    @ConfigValue(section="relay", name="host", example={"\"localhost\""})
    private String serviceHost;
    @Parameter(names={"--service-port"}, description="Port where the service that supports WebDriver commands is running")
    @ConfigValue(section="relay", name="port", example={"4723"})
    private Integer servicePort;
    @Parameter(names={"--service-status-endpoint"}, description="Endpoint to query the WebDriver service status, an HTTP 200 response is expected")
    @ConfigValue(section="relay", name="status-endpoint", example={"\"/status\""})
    private String serviceStatusEndpoint;

    @Override
    public Set<Role> getRoles() {
        return Collections.singleton(StandardGridRoles.NODE_ROLE);
    }
}

