/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.web;

import com.google.common.collect.ImmutableMap;
import com.google.common.net.MediaType;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

public class NoHandler
implements HttpHandler {
    private final Json json;

    public NoHandler(Json json) {
        this.json = (Json)Require.nonNull((String)"Json converter", (Object)json);
    }

    public HttpResponse execute(HttpRequest req) throws UncheckedIOException {
        Map<String, Object> responseMap = new HashMap<String, ImmutableMap>();
        responseMap.put("sessionId", null);
        responseMap.put("value", ImmutableMap.of((Object)"error", (Object)"unknown command", (Object)"message", (Object)String.format("Unable to find command matching %s to %s", req.getMethod(), req.getUri()), (Object)"stacktrace", (Object)""));
        responseMap = Collections.unmodifiableMap(responseMap);
        byte[] payload = this.json.toJson(responseMap).getBytes(StandardCharsets.UTF_8);
        return (HttpResponse)((HttpResponse)((HttpResponse)new HttpResponse().setStatus(404).setHeader("Content-Type", MediaType.JSON_UTF_8.toString())).setHeader("Content-Length", String.valueOf(payload.length))).setContent(Contents.bytes((byte[])payload));
    }
}

