/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.sessionqueue;

import java.util.Collections;
import org.openqa.selenium.grid.sessionqueue.NewSessionQueue;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.HttpTracing;
import org.openqa.selenium.remote.tracing.Span;
import org.openqa.selenium.remote.tracing.Tags;
import org.openqa.selenium.remote.tracing.Tracer;

class GetSessionQueue
implements HttpHandler {
    private final Tracer tracer;
    private final NewSessionQueue newSessionQueue;

    GetSessionQueue(Tracer tracer, NewSessionQueue newSessionQueue) {
        this.tracer = (Tracer)Require.nonNull((String)"Tracer", (Object)tracer);
        this.newSessionQueue = (NewSessionQueue)Require.nonNull((String)"New Session Queue", (Object)newSessionQueue);
    }

    public HttpResponse execute(HttpRequest req) {
        try (Span span = HttpTracing.newSpanAsChildOf((Tracer)this.tracer, (HttpRequest)req, (String)"sessionqueue.contents");){
            Tags.HTTP_REQUEST.accept(span, req);
            HttpResponse response = (HttpResponse)new HttpResponse().setContent(Contents.asJson(Collections.singletonMap("value", this.newSessionQueue.getQueueContents())));
            Tags.HTTP_RESPONSE.accept(span, response);
            HttpResponse httpResponse = response;
            return httpResponse;
        }
    }
}

