/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.netty.server;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import java.nio.ByteBuffer;
import java.util.logging.Logger;
import org.openqa.selenium.remote.http.BinaryMessage;
import org.openqa.selenium.remote.http.CloseMessage;
import org.openqa.selenium.remote.http.TextMessage;

class MessageInboundConverter
extends SimpleChannelInboundHandler<WebSocketFrame> {
    private static final Logger LOG = Logger.getLogger(MessageInboundConverter.class.getName());

    MessageInboundConverter() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void channelRead0(ChannelHandlerContext ctx, WebSocketFrame frame) {
        if (!frame.isFinalFragment()) {
            LOG.warning("Frame is not final. Chaos may ensue");
        }
        TextMessage message = null;
        if (frame instanceof TextWebSocketFrame) {
            message = new TextMessage((CharSequence)((TextWebSocketFrame)frame).text());
        } else if (frame instanceof BinaryWebSocketFrame) {
            ByteBuf buf = frame.content();
            if (buf.nioBufferCount() != -1) {
                message = new BinaryMessage(buf.nioBuffer());
            } else {
                if (!buf.hasArray()) throw new IllegalStateException("Unable to handle bytebuf: " + buf);
                message = new BinaryMessage(ByteBuffer.wrap(buf.array()));
            }
        } else if (frame instanceof CloseWebSocketFrame) {
            CloseWebSocketFrame closeFrame = (CloseWebSocketFrame)frame;
            message = new CloseMessage(closeFrame.statusCode(), closeFrame.reasonText());
        }
        if (message != null) {
            ctx.fireChannelRead((Object)message);
            return;
        } else {
            ctx.write((Object)frame);
        }
    }
}

