/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.htmlunit;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.CookieManager;
import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.ProxyConfig;
import com.gargoylesoftware.htmlunit.RefreshHandler;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.TopLevelWindow;
import com.gargoylesoftware.htmlunit.WaitingRefreshHandler;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.WebWindowEvent;
import com.gargoylesoftware.htmlunit.WebWindowListener;
import com.gargoylesoftware.htmlunit.WebWindowNotFoundException;
import com.gargoylesoftware.htmlunit.html.BaseFrame;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomNodeList;
import com.gargoylesoftware.htmlunit.html.FrameWindow;
import com.gargoylesoftware.htmlunit.html.HtmlAnchor;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCollection;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.NativeArray;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.HasInputDevices;
import org.openqa.selenium.InvalidCookieDomainException;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Keyboard;
import org.openqa.selenium.Mouse;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.NoSuchFrameException;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.Speed;
import org.openqa.selenium.UnableToSetCookieException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.browserlaunchers.Proxies;
import org.openqa.selenium.htmlunit.AsyncScriptExecutor;
import org.openqa.selenium.htmlunit.HtmlUnitKeyboard;
import org.openqa.selenium.htmlunit.HtmlUnitMouse;
import org.openqa.selenium.htmlunit.HtmlUnitWebElement;
import org.openqa.selenium.internal.FindsByCssSelector;
import org.openqa.selenium.internal.FindsById;
import org.openqa.selenium.internal.FindsByLinkText;
import org.openqa.selenium.internal.FindsByName;
import org.openqa.selenium.internal.FindsByTagName;
import org.openqa.selenium.internal.FindsByXPath;
import org.openqa.selenium.internal.WrapsElement;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlUnitDriver
implements WebDriver,
SearchContext,
JavascriptExecutor,
FindsById,
FindsByLinkText,
FindsByXPath,
FindsByName,
FindsByCssSelector,
FindsByTagName,
HasInputDevices {
    private WebClient webClient;
    private WebWindow currentWindow;
    private boolean enableJavascript;
    private ProxyConfig proxyConfig;
    private final BrowserVersion version;
    private Speed speed = Speed.FAST;
    private long implicitWait = 0L;
    private long scriptTimeout = 0L;
    private HtmlUnitKeyboard keyboard;
    private HtmlUnitMouse mouse;

    public HtmlUnitDriver(BrowserVersion version) {
        this.version = version;
        this.webClient = this.createWebClient(version);
        this.currentWindow = this.webClient.getCurrentWindow();
        this.webClient.addWebWindowListener(new WebWindowListener(){

            public void webWindowOpened(WebWindowEvent webWindowEvent) {
            }

            public void webWindowContentChanged(WebWindowEvent event) {
                if (event.getWebWindow() != HtmlUnitDriver.this.currentWindow) {
                    return;
                }
                HtmlUnitDriver.this.switchToDefaultContentOfWindow(HtmlUnitDriver.this.currentWindow);
            }

            public void webWindowClosed(WebWindowEvent event) {
                WebWindow curr = HtmlUnitDriver.this.currentWindow;
                do {
                    if (curr != event.getWebWindow()) continue;
                    HtmlUnitDriver.this.currentWindow = HtmlUnitDriver.this.currentWindow.getTopWindow();
                    return;
                } while ((curr = curr.getParentWindow()) != HtmlUnitDriver.this.currentWindow.getTopWindow());
            }
        });
        this.get(this.webClient.getHomePage());
        this.keyboard = new HtmlUnitKeyboard(this);
        this.mouse = new HtmlUnitMouse(this, this.keyboard);
    }

    public HtmlUnitDriver() {
        this(false);
    }

    public HtmlUnitDriver(boolean enableJavascript) {
        this(BrowserVersion.getDefault());
        this.setJavascriptEnabled(enableJavascript);
    }

    public HtmlUnitDriver(Capabilities capabilities) {
        this(HtmlUnitDriver.determineBrowserVersion(capabilities));
        Proxy proxy;
        String fullProxy;
        this.setJavascriptEnabled(capabilities.isJavascriptEnabled());
        if (capabilities.getCapability("proxy") != null && (fullProxy = (proxy = Proxies.extractProxy((Capabilities)capabilities)).getHttpProxy()) != null) {
            int index = fullProxy.indexOf(":");
            if (index != -1) {
                String host = fullProxy.substring(0, index);
                int port = Integer.parseInt(fullProxy.substring(index + 1));
                this.setProxy(host, port);
            } else {
                this.setProxy(fullProxy, 0);
            }
        }
    }

    private static BrowserVersion determineBrowserVersion(Capabilities capabilities) {
        String browserName = capabilities.getBrowserName();
        if ("firefox".equals(browserName)) {
            return BrowserVersion.FIREFOX_3;
        }
        if ("internet explorer".equals(browserName)) {
            try {
                int version = Integer.parseInt(capabilities.getVersion());
                switch (version) {
                    case 6: {
                        return BrowserVersion.INTERNET_EXPLORER_6;
                    }
                    case 7: {
                        return BrowserVersion.INTERNET_EXPLORER_7;
                    }
                    case 8: {
                        return BrowserVersion.INTERNET_EXPLORER_8;
                    }
                }
            }
            catch (NumberFormatException e) {
                return BrowserVersion.INTERNET_EXPLORER_8;
            }
        }
        return BrowserVersion.getDefault();
    }

    private WebClient createWebClient(BrowserVersion version) {
        WebClient client = this.newWebClient(version);
        client.setHomePage(WebClient.URL_ABOUT_BLANK.toString());
        client.setThrowExceptionOnFailingStatusCode(false);
        client.setPrintContentOnFailingStatusCode(false);
        client.setJavaScriptEnabled(this.enableJavascript);
        client.setRedirectEnabled(true);
        client.setRefreshHandler((RefreshHandler)new WaitingRefreshHandler());
        try {
            client.setUseInsecureSSL(true);
        }
        catch (GeneralSecurityException e) {
            throw new WebDriverException((Throwable)e);
        }
        if (this.proxyConfig != null) {
            client.setProxyConfig(this.proxyConfig);
        }
        return this.modifyWebClient(client);
    }

    protected WebClient newWebClient(BrowserVersion version) {
        return new WebClient(version);
    }

    protected WebClient modifyWebClient(WebClient client) {
        return client;
    }

    public void setProxy(String host, int port) {
        this.proxyConfig = new ProxyConfig(host, port);
        this.webClient.setProxyConfig(this.proxyConfig);
    }

    public void setAutoProxy(String autoProxyUrl) {
        this.proxyConfig = new ProxyConfig();
        this.proxyConfig.setProxyAutoConfigUrl(autoProxyUrl);
        this.webClient.setProxyConfig(this.proxyConfig);
    }

    public void get(String url) {
        URL fullUrl;
        if (WebClient.URL_ABOUT_BLANK.toString().equals(url)) {
            this.get(WebClient.URL_ABOUT_BLANK);
            return;
        }
        try {
            fullUrl = new URL(url);
        }
        catch (Exception e) {
            throw new WebDriverException((Throwable)e);
        }
        this.get(fullUrl);
    }

    protected void get(URL fullUrl) {
        try {
            this.currentWindow = this.currentWindow.getTopWindow();
            this.webClient.getPage(fullUrl);
        }
        catch (UnknownHostException e) {
        }
        catch (ConnectException e) {
        }
        catch (Exception e) {
            throw new WebDriverException((Throwable)e);
        }
        this.pickWindow();
    }

    protected void pickWindow() {
        if (this.currentWindow == null) {
            this.currentWindow = this.webClient.getCurrentWindow();
        }
    }

    public String getCurrentUrl() {
        URL url = this.getRawUrl();
        if (url == null) {
            return null;
        }
        return url.toString();
    }

    public String getTitle() {
        Page page = this.lastPage();
        if (page == null || !(page instanceof HtmlPage)) {
            return null;
        }
        if (this.currentWindow instanceof FrameWindow) {
            page = ((FrameWindow)this.currentWindow).getTopWindow().getEnclosedPage();
        }
        return ((HtmlPage)page).getTitleText();
    }

    public WebElement findElement(By by) {
        return this.findElement(by, this);
    }

    public List<WebElement> findElements(By by) {
        return this.findElements(by, this);
    }

    public String getPageSource() {
        Page page = this.lastPage();
        if (page == null) {
            return null;
        }
        if (page instanceof SgmlPage) {
            return ((SgmlPage)page).asXml();
        }
        WebResponse response = page.getWebResponse();
        return response.getContentAsString();
    }

    public void close() {
        if (this.currentWindow != null) {
            ((TopLevelWindow)this.currentWindow.getTopWindow()).close();
        }
        this.webClient = this.createWebClient(this.version);
    }

    public void quit() {
        if (this.webClient != null) {
            this.webClient.closeAllWindows();
            this.webClient = null;
        }
        this.currentWindow = null;
    }

    public Set<String> getWindowHandles() {
        HashSet<String> allHandles = new HashSet<String>();
        for (TopLevelWindow window : this.webClient.getTopLevelWindows()) {
            allHandles.add(String.valueOf(System.identityHashCode(window)));
        }
        return allHandles;
    }

    public String getWindowHandle() {
        return String.valueOf(System.identityHashCode(this.currentWindow.getTopWindow()));
    }

    public Object executeScript(String script, Object ... args) {
        HtmlPage page = this.getPageToInjectScriptInto();
        Object[] parameters = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            parameters[i] = this.parseArgumentIntoJavsacriptParameter(args[i]);
        }
        script = "function() {" + script + "};";
        ScriptResult result = page.executeJavaScript(script);
        Function func = (Function)result.getJavaScriptResult();
        result = page.executeJavaScriptFunctionIfPossible(func, (Scriptable)((ScriptableObject)this.currentWindow.getScriptObject()), parameters, (DomNode)page.getDocumentElement());
        return this.parseNativeJavascriptResult(result);
    }

    public Object executeAsyncScript(String script, Object ... args) {
        HtmlPage page = this.getPageToInjectScriptInto();
        Object result = new AsyncScriptExecutor(page, this.scriptTimeout).execute(script, args);
        return this.parseNativeJavascriptResult(result);
    }

    private HtmlPage getPageToInjectScriptInto() {
        if (!this.isJavascriptEnabled()) {
            throw new UnsupportedOperationException("Javascript is not enabled for this HtmlUnitDriver instance");
        }
        if (!(this.lastPage() instanceof HtmlPage)) {
            throw new UnsupportedOperationException("Cannot execute JS against a plain text page");
        }
        return (HtmlPage)this.lastPage();
    }

    private Object parseArgumentIntoJavsacriptParameter(Object arg) {
        if (!(arg instanceof HtmlUnitWebElement || arg instanceof HtmlElement || arg instanceof Number || arg instanceof String || arg instanceof Boolean || arg.getClass().isArray() || arg instanceof Collection)) {
            throw new IllegalArgumentException("Argument must be a string, number, boolean or WebElement: " + arg + " (" + arg.getClass() + ")");
        }
        if (arg instanceof HtmlUnitWebElement) {
            HtmlElement element = ((HtmlUnitWebElement)arg).getElement();
            return element.getScriptObject();
        }
        if (arg instanceof HtmlElement) {
            return ((HtmlElement)arg).getScriptObject();
        }
        if (arg instanceof Collection) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (Object o : (Collection)arg) {
                list.add(this.parseArgumentIntoJavsacriptParameter(o));
            }
            return list.toArray();
        }
        return arg;
    }

    public Keyboard getKeyboard() {
        return this.keyboard;
    }

    public Mouse getMouse() {
        return this.mouse;
    }

    private Object parseNativeJavascriptResult(Object result) {
        Object value = result instanceof ScriptResult ? ((ScriptResult)result).getJavaScriptResult() : result;
        if (value instanceof HTMLElement) {
            return this.newHtmlUnitWebElement(((HTMLElement)value).getDomNodeOrDie());
        }
        if (value instanceof Number) {
            if (value instanceof Float || value instanceof Double) {
                return ((Number)value).doubleValue();
            }
            return ((Number)value).longValue();
        }
        if (value instanceof NativeArray) {
            final NativeArray array = (NativeArray)value;
            JavaScriptResultsCollection collection = new JavaScriptResultsCollection(){

                public int getLength() {
                    return (int)array.getLength();
                }

                public Object item(int index) {
                    return array.get((Object)index);
                }
            };
            return this.parseJavascriptResultsList(collection);
        }
        if (value instanceof HTMLCollection) {
            final HTMLCollection array = (HTMLCollection)value;
            JavaScriptResultsCollection collection = new JavaScriptResultsCollection(){

                public int getLength() {
                    return array.getLength();
                }

                public Object item(int index) {
                    return array.get((Object)index);
                }
            };
            return this.parseJavascriptResultsList(collection);
        }
        if (value instanceof Undefined) {
            return null;
        }
        return value;
    }

    private List<Object> parseJavascriptResultsList(JavaScriptResultsCollection array) {
        ArrayList<Object> list = new ArrayList<Object>(array.getLength());
        for (int i = 0; i < array.getLength(); ++i) {
            list.add(this.parseNativeJavascriptResult(array.item(i)));
        }
        return list;
    }

    public WebDriver.TargetLocator switchTo() {
        return new HtmlUnitTargetLocator();
    }

    private void switchToDefaultContentOfWindow(WebWindow window) {
        Page page = window.getEnclosedPage();
        if (page instanceof HtmlPage) {
            this.currentWindow = window;
        }
    }

    public WebDriver.Navigation navigate() {
        return new HtmlUnitNavigation();
    }

    protected Page lastPage() {
        return this.currentWindow.getEnclosedPage();
    }

    public WebElement findElementByLinkText(String selector) {
        int equalsIndex = selector.indexOf(61) + 1;
        String expectedText = selector.substring(equalsIndex).trim();
        if (!(this.lastPage() instanceof HtmlPage)) {
            throw new IllegalStateException("Cannot find links for " + this.lastPage());
        }
        List anchors = ((HtmlPage)this.lastPage()).getAnchors();
        for (HtmlAnchor anchor : anchors) {
            if (!expectedText.equals(anchor.asText())) continue;
            return this.newHtmlUnitWebElement((HtmlElement)anchor);
        }
        throw new NoSuchElementException("No link found with text: " + expectedText);
    }

    protected WebElement newHtmlUnitWebElement(HtmlElement element) {
        return new HtmlUnitWebElement(this, element);
    }

    public List<WebElement> findElementsByLinkText(String selector) {
        ArrayList<WebElement> elements = new ArrayList<WebElement>();
        if (!(this.lastPage() instanceof HtmlPage)) {
            return elements;
        }
        int equalsIndex = selector.indexOf(61) + 1;
        String expectedText = selector.substring(equalsIndex).trim();
        List anchors = ((HtmlPage)this.lastPage()).getAnchors();
        for (HtmlAnchor anchor : anchors) {
            if (!expectedText.equals(anchor.asText())) continue;
            elements.add(this.newHtmlUnitWebElement((HtmlElement)anchor));
        }
        return elements;
    }

    public WebElement findElementById(String id) {
        if (!(this.lastPage() instanceof HtmlPage)) {
            throw new NoSuchElementException("Unable to locate element by id for " + this.lastPage());
        }
        try {
            HtmlElement element = ((HtmlPage)this.lastPage()).getHtmlElementById(id);
            return this.newHtmlUnitWebElement(element);
        }
        catch (ElementNotFoundException e) {
            throw new NoSuchElementException("Unable to locate element with ID: " + id);
        }
    }

    public List<WebElement> findElementsById(String id) {
        return this.findElementsByXPath("//*[@id='" + id + "']");
    }

    public WebElement findElementByCssSelector(String using) {
        if (!(this.lastPage() instanceof HtmlPage)) {
            throw new NoSuchElementException("Unable to locate element using css: " + this.lastPage());
        }
        DomNode node = ((HtmlPage)this.lastPage()).querySelector(using);
        if (node instanceof HtmlElement) {
            return this.newHtmlUnitWebElement((HtmlElement)node);
        }
        throw new NoSuchElementException("Returned node was not an HTML element");
    }

    public List<WebElement> findElementsByCssSelector(String using) {
        if (!(this.lastPage() instanceof HtmlPage)) {
            throw new NoSuchElementException("Unable to locate element using css: " + this.lastPage());
        }
        DomNodeList allNodes = ((HtmlPage)this.lastPage()).querySelectorAll(using);
        ArrayList<WebElement> toReturn = new ArrayList<WebElement>();
        for (DomNode node : allNodes) {
            if (node instanceof HtmlElement) {
                toReturn.add(this.newHtmlUnitWebElement((HtmlElement)node));
                continue;
            }
            throw new NoSuchElementException("Returned node was not an HTML element");
        }
        return toReturn;
    }

    public WebElement findElementByName(String name) {
        if (!(this.lastPage() instanceof HtmlPage)) {
            throw new IllegalStateException("Unable to locate element by name for " + this.lastPage());
        }
        List allElements = ((HtmlPage)this.lastPage()).getElementsByName(name);
        if (allElements.size() > 0) {
            return this.newHtmlUnitWebElement((HtmlElement)allElements.get(0));
        }
        throw new NoSuchElementException("Unable to locate element with name: " + name);
    }

    public List<WebElement> findElementsByName(String using) {
        if (!(this.lastPage() instanceof HtmlPage)) {
            return new ArrayList<WebElement>();
        }
        List allElements = ((HtmlPage)this.lastPage()).getElementsByName(using);
        return this.convertRawHtmlElementsToWebElements(allElements);
    }

    public WebElement findElementByTagName(String name) {
        if (!(this.lastPage() instanceof HtmlPage)) {
            throw new IllegalStateException("Unable to locate element by name for " + this.lastPage());
        }
        DomNodeList allElements = ((HtmlPage)this.lastPage()).getElementsByTagName(name);
        if (allElements.getLength() > 0) {
            return this.newHtmlUnitWebElement((HtmlElement)allElements.item(0));
        }
        throw new NoSuchElementException("Unable to locate element with name: " + name);
    }

    public List<WebElement> findElementsByTagName(String using) {
        if (!(this.lastPage() instanceof HtmlPage)) {
            return new ArrayList<WebElement>();
        }
        DomNodeList allElements = ((HtmlPage)this.lastPage()).getElementsByTagName(using);
        ArrayList<WebElement> toReturn = new ArrayList<WebElement>(allElements.getLength());
        for (int i = 0; i < allElements.getLength(); ++i) {
            Node item = allElements.item(i);
            if (!(item instanceof HtmlElement)) continue;
            toReturn.add(this.newHtmlUnitWebElement((HtmlElement)item));
        }
        return toReturn;
    }

    public WebElement findElementByXPath(String selector) {
        if (!(this.lastPage() instanceof HtmlPage)) {
            throw new IllegalStateException("Unable to locate element by xpath for " + this.lastPage());
        }
        Object node = ((HtmlPage)this.lastPage()).getFirstByXPath(selector);
        if (node == null) {
            throw new NoSuchElementException("Unable to locate a node using " + selector);
        }
        if (node instanceof HtmlElement) {
            return this.newHtmlUnitWebElement((HtmlElement)node);
        }
        throw new NoSuchElementException(String.format("Unable to locate element with xpath %s", selector));
    }

    public List<WebElement> findElementsByXPath(String selector) {
        if (!(this.lastPage() instanceof HtmlPage)) {
            return new ArrayList<WebElement>();
        }
        List nodes = ((HtmlPage)this.lastPage()).getByXPath(selector);
        return this.convertRawHtmlElementsToWebElements(nodes);
    }

    private List<WebElement> convertRawHtmlElementsToWebElements(List<?> nodes) {
        ArrayList<WebElement> elements = new ArrayList<WebElement>();
        for (Object node : nodes) {
            if (!(node instanceof HtmlElement)) continue;
            elements.add(this.newHtmlUnitWebElement((HtmlElement)node));
        }
        return elements;
    }

    public boolean isJavascriptEnabled() {
        return this.webClient.isJavaScriptEnabled();
    }

    public void setJavascriptEnabled(boolean enableJavascript) {
        this.enableJavascript = enableJavascript;
        this.webClient.setJavaScriptEnabled(enableJavascript);
    }

    protected <X> X implicitlyWaitFor(Callable<X> condition) {
        long end = System.currentTimeMillis() + this.implicitWait;
        Exception lastException = null;
        do {
            X toReturn = null;
            try {
                toReturn = condition.call();
            }
            catch (Exception e) {
                lastException = e;
            }
            if (toReturn instanceof Boolean && !((Boolean)toReturn).booleanValue()) continue;
            if (toReturn != null) {
                return toReturn;
            }
            HtmlUnitDriver.sleepQuietly(200L);
        } while (System.currentTimeMillis() < end);
        if (lastException != null) {
            if (lastException instanceof RuntimeException) {
                throw (RuntimeException)lastException;
            }
            throw new WebDriverException((Throwable)lastException);
        }
        return null;
    }

    protected WebClient getWebClient() {
        return this.webClient;
    }

    protected WebWindow getCurrentWindow() {
        return this.currentWindow;
    }

    private URL getRawUrl() {
        Page page = this.lastPage();
        if (page == null) {
            return null;
        }
        return page.getUrl();
    }

    public WebDriver.Options manage() {
        return new HtmlUnitOptions();
    }

    public WebElement findElementByPartialLinkText(String using) {
        if (!(this.lastPage() instanceof HtmlPage)) {
            throw new IllegalStateException("Cannot find links for " + this.lastPage());
        }
        List anchors = ((HtmlPage)this.lastPage()).getAnchors();
        for (HtmlAnchor anchor : anchors) {
            if (!anchor.asText().contains(using)) continue;
            return this.newHtmlUnitWebElement((HtmlElement)anchor);
        }
        throw new NoSuchElementException("No link found with text: " + using);
    }

    public List<WebElement> findElementsByPartialLinkText(String using) {
        List anchors = ((HtmlPage)this.lastPage()).getAnchors();
        Iterator allAnchors = anchors.iterator();
        ArrayList<WebElement> elements = new ArrayList<WebElement>();
        while (allAnchors.hasNext()) {
            HtmlAnchor anchor = (HtmlAnchor)allAnchors.next();
            if (!anchor.asText().contains(using)) continue;
            elements.add(this.newHtmlUnitWebElement((HtmlElement)anchor));
        }
        return elements;
    }

    WebElement findElement(final By locator, final SearchContext context) {
        return this.implicitlyWaitFor(new Callable<WebElement>(){

            @Override
            public WebElement call() throws Exception {
                return locator.findElement(context);
            }
        });
    }

    List<WebElement> findElements(By by, SearchContext context) {
        List found;
        long end = System.currentTimeMillis() + this.implicitWait;
        do {
            if ((found = by.findElements(context)).isEmpty()) continue;
            return found;
        } while (System.currentTimeMillis() < end);
        return found;
    }

    private static void sleepQuietly(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    class HtmlUnitTimeouts
    implements WebDriver.Timeouts {
        HtmlUnitTimeouts() {
        }

        public WebDriver.Timeouts implicitlyWait(long time, TimeUnit unit) {
            HtmlUnitDriver.this.implicitWait = TimeUnit.MILLISECONDS.convert(Math.max(0L, time), unit);
            return this;
        }

        public WebDriver.Timeouts setScriptTimeout(long time, TimeUnit unit) {
            HtmlUnitDriver.this.scriptTimeout = TimeUnit.MILLISECONDS.convert(time, unit);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HtmlUnitOptions
    implements WebDriver.Options {
        private HtmlUnitOptions() {
        }

        public void addCookie(Cookie cookie) {
            Page page = HtmlUnitDriver.this.lastPage();
            if (!(page instanceof HtmlPage)) {
                throw new UnableToSetCookieException("You may not set cookies on a page that is not HTML");
            }
            String domain = this.getDomainForCookie();
            this.verifyDomain(cookie, domain);
            HtmlUnitDriver.this.webClient.getCookieManager().addCookie(new com.gargoylesoftware.htmlunit.util.Cookie(domain, cookie.getName(), cookie.getValue(), cookie.getPath(), cookie.getExpiry(), cookie.isSecure()));
        }

        private void verifyDomain(Cookie cookie, String expectedDomain) {
            String domain = cookie.getDomain();
            if (domain == null) {
                return;
            }
            if ("".equals(domain)) {
                throw new InvalidCookieDomainException("Domain must not be an empty string. Consider using null instead");
            }
            if (domain.matches(".*[^:]:\\d+$")) {
                domain = domain.replaceFirst(":\\d+$", "");
            }
            expectedDomain = expectedDomain.startsWith(".") ? expectedDomain : "." + expectedDomain;
            String string = domain = domain.startsWith(".") ? domain : "." + domain;
            if (!expectedDomain.endsWith(domain)) {
                throw new InvalidCookieDomainException(String.format("You may only add cookies that would be visible to the current domain: %s => %s", domain, expectedDomain));
            }
        }

        public Cookie getCookieNamed(String name) {
            Set<Cookie> allCookies = this.getCookies();
            for (Cookie cookie : allCookies) {
                if (!name.equals(cookie.getName())) continue;
                return cookie;
            }
            return null;
        }

        public void deleteCookieNamed(String name) {
            CookieManager cookieManager = HtmlUnitDriver.this.webClient.getCookieManager();
            URL url = HtmlUnitDriver.this.getRawUrl();
            Set rawCookies = HtmlUnitDriver.this.webClient.getCookieManager().getCookies(url);
            for (com.gargoylesoftware.htmlunit.util.Cookie cookie : rawCookies) {
                if (!name.equals(cookie.getName())) continue;
                cookieManager.removeCookie(cookie);
            }
        }

        public void deleteCookie(Cookie cookie) {
            this.deleteCookieNamed(cookie.getName());
        }

        public void deleteAllCookies() {
            HtmlUnitDriver.this.webClient.getCookieManager().clearCookies();
        }

        public Set<Cookie> getCookies() {
            URL url = HtmlUnitDriver.this.getRawUrl();
            if (!url.toString().startsWith("http")) {
                return new HashSet<Cookie>();
            }
            Set rawCookies = HtmlUnitDriver.this.webClient.getCookieManager().getCookies(url);
            HashSet<Cookie> retCookies = new HashSet<Cookie>();
            for (com.gargoylesoftware.htmlunit.util.Cookie c : rawCookies) {
                if (c.getPath() == null || !this.getPath().toLowerCase().startsWith(c.getPath())) continue;
                retCookies.add(new Cookie.Builder(c.getName(), c.getValue()).domain(c.getDomain()).path(c.getPath()).expiresOn(c.getExpires()).isSecure(c.isSecure()).build());
            }
            return retCookies;
        }

        private String getPath() {
            return HtmlUnitDriver.this.getRawUrl().getPath();
        }

        public Speed getSpeed() {
            return HtmlUnitDriver.this.speed;
        }

        public void setSpeed(Speed speed) {
            HtmlUnitDriver.this.speed = speed;
        }

        private String getDomainForCookie() {
            URL current = HtmlUnitDriver.this.getRawUrl();
            return current.getHost();
        }

        public WebDriver.Timeouts timeouts() {
            return new HtmlUnitTimeouts();
        }
    }

    private class HtmlUnitNavigation
    implements WebDriver.Navigation {
        private HtmlUnitNavigation() {
        }

        public void back() {
            try {
                HtmlUnitDriver.this.currentWindow.getHistory().back();
            }
            catch (IOException e) {
                throw new WebDriverException((Throwable)e);
            }
        }

        public void forward() {
            try {
                HtmlUnitDriver.this.currentWindow.getHistory().forward();
            }
            catch (IOException e) {
                throw new WebDriverException((Throwable)e);
            }
        }

        public void to(String url) {
            HtmlUnitDriver.this.get(url);
        }

        public void to(URL url) {
            HtmlUnitDriver.this.get(url);
        }

        public void refresh() {
            if (HtmlUnitDriver.this.lastPage() instanceof HtmlPage) {
                try {
                    ((HtmlPage)HtmlUnitDriver.this.lastPage()).refresh();
                }
                catch (IOException e) {
                    throw new WebDriverException((Throwable)e);
                }
            }
        }
    }

    private class HtmlUnitTargetLocator
    implements WebDriver.TargetLocator {
        private HtmlUnitTargetLocator() {
        }

        public WebDriver frame(int index) {
            HtmlPage currentPage = (HtmlPage)HtmlUnitDriver.this.currentWindow.getEnclosedPage();
            try {
                HtmlUnitDriver.this.currentWindow = (WebWindow)currentPage.getFrames().get(index);
            }
            catch (IndexOutOfBoundsException ignored) {
                throw new NoSuchFrameException("Cannot find frame: " + index);
            }
            return HtmlUnitDriver.this;
        }

        public WebDriver frame(String nameOrId) {
            HtmlPage startPage = (HtmlPage)HtmlUnitDriver.this.currentWindow.getEnclosedPage();
            for (FrameWindow frameWindow : startPage.getFrames()) {
                if (!frameWindow.getName().equals(nameOrId)) continue;
                HtmlUnitDriver.this.currentWindow = (WebWindow)frameWindow;
                return HtmlUnitDriver.this;
            }
            try {
                HtmlUnitWebElement element = (HtmlUnitWebElement)HtmlUnitDriver.this.findElementById(nameOrId);
                HtmlElement domElement = element.getElement();
                if (domElement instanceof BaseFrame) {
                    HtmlUnitDriver.this.currentWindow = ((BaseFrame)domElement).getEnclosedWindow();
                    return HtmlUnitDriver.this;
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            throw new NoSuchFrameException("Unable to locate frame with name or ID: " + nameOrId);
        }

        public WebDriver frame(WebElement frameElement) {
            while (frameElement instanceof WrapsElement) {
                frameElement = ((WrapsElement)frameElement).getWrappedElement();
            }
            HtmlUnitWebElement webElement = (HtmlUnitWebElement)frameElement;
            webElement.assertElementNotStale();
            HtmlElement domElement = webElement.getElement();
            if (!(domElement instanceof BaseFrame)) {
                throw new NoSuchFrameException(webElement.getTagName() + " is not a frame element.");
            }
            HtmlUnitDriver.this.currentWindow = ((BaseFrame)domElement).getEnclosedWindow();
            return HtmlUnitDriver.this;
        }

        private WebWindow getWindowByNumericFrameId(String currentFrameId, HtmlPage page) {
            try {
                int index = Integer.parseInt(currentFrameId);
                return (WebWindow)page.getFrames().get(index);
            }
            catch (NumberFormatException e) {
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            return null;
        }

        public WebDriver window(String windowId) {
            try {
                WebWindow window = HtmlUnitDriver.this.webClient.getWebWindowByName(windowId);
                return this.finishSelecting(window);
            }
            catch (WebWindowNotFoundException e) {
                List allWindows = HtmlUnitDriver.this.webClient.getWebWindows();
                for (WebWindow current : allWindows) {
                    WebWindow top = current.getTopWindow();
                    if (!String.valueOf(System.identityHashCode(top)).equals(windowId)) continue;
                    return this.finishSelecting(top);
                }
                throw new NoSuchWindowException("Cannot find window: " + windowId);
            }
        }

        private WebDriver finishSelecting(WebWindow window) {
            HtmlUnitDriver.this.webClient.setCurrentWindow(window);
            HtmlUnitDriver.this.currentWindow = window;
            HtmlUnitDriver.this.pickWindow();
            return HtmlUnitDriver.this;
        }

        public WebDriver defaultContent() {
            HtmlUnitDriver.this.switchToDefaultContentOfWindow(HtmlUnitDriver.this.currentWindow.getTopWindow());
            return HtmlUnitDriver.this;
        }

        public WebElement activeElement() {
            Page page = HtmlUnitDriver.this.currentWindow.getEnclosedPage();
            if (page instanceof HtmlPage) {
                HtmlElement element = ((HtmlPage)page).getFocusedElement();
                if (element == null) {
                    List allBodies = ((HtmlPage)page).getDocumentElement().getHtmlElementsByTagName("body");
                    if (allBodies.size() > 0) {
                        return HtmlUnitDriver.this.newHtmlUnitWebElement((HtmlElement)allBodies.get(0));
                    }
                } else {
                    return HtmlUnitDriver.this.newHtmlUnitWebElement(element);
                }
            }
            throw new NoSuchElementException("Unable to locate element with focus or body tag");
        }

        public Alert alert() {
            throw new UnsupportedOperationException("alert()");
        }
    }

    protected static interface JavaScriptResultsCollection {
        public int getLength();

        public Object item(int var1);
    }
}

