/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.handler.interactions.touch;

import java.util.Map;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Coordinates;
import org.openqa.selenium.interactions.Locatable;
import org.openqa.selenium.remote.server.Session;
import org.openqa.selenium.remote.server.handler.WebElementHandler;
import org.openqa.selenium.remote.server.handler.interactions.HasTouchScreen;
import org.openqa.selenium.remote.server.handler.interactions.TouchScreen;

public class LongPressOnElement
extends WebElementHandler<Void> {
    private static final String ELEMENT = "element";
    private String elementId;

    public LongPressOnElement(Session session) {
        super(session);
    }

    @Override
    public void setJsonParameters(Map<String, Object> allParameters) throws Exception {
        super.setJsonParameters(allParameters);
        this.elementId = (String)allParameters.get(ELEMENT);
    }

    @Override
    public Void call() {
        TouchScreen touchScreen = ((HasTouchScreen)this.getDriver()).getTouch();
        WebElement element = this.getKnownElements().get(this.elementId);
        Coordinates elementLocation = ((Locatable)element).getCoordinates();
        touchScreen.longPress(elementLocation);
        return null;
    }

    public String toString() {
        return String.format("[Long press: %s]", this.elementId);
    }
}

