/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.manager;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.Beta;
import org.openqa.selenium.BuildInfo;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonException;
import org.openqa.selenium.manager.SeleniumManagerOutput;
import org.openqa.selenium.os.ExternalProcess;

@Beta
public class SeleniumManager {
    private static final Logger LOG = Logger.getLogger(SeleniumManager.class.getName());
    private static final String SELENIUM_MANAGER = "selenium-manager";
    private static final String DEFAULT_CACHE_PATH = "~/.cache/selenium";
    private static final String BINARY_PATH_FORMAT = "/manager/%s/%s";
    private static final String HOME = "~";
    private static final String CACHE_PATH_ENV = "SE_CACHE_PATH";
    private static final String BETA_PREFIX = "0.";
    private static final String EXE = ".exe";
    private static final String SE_ENV_PREFIX = "SE_";
    private static volatile SeleniumManager manager;
    private final String managerPath = System.getenv("SE_MANAGER_PATH");
    private Path binary = this.managerPath == null ? null : Paths.get(this.managerPath, new String[0]);
    private final String seleniumManagerVersion;
    private boolean binaryInTemporalFolder = false;

    private SeleniumManager() {
        BuildInfo info = new BuildInfo();
        String releaseLabel = info.getReleaseLabel();
        int lastDot = releaseLabel.lastIndexOf(".");
        this.seleniumManagerVersion = BETA_PREFIX + releaseLabel.substring(0, lastDot);
        if (this.managerPath == null) {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                if (this.binaryInTemporalFolder && this.binary != null && Files.exists(this.binary, new LinkOption[0])) {
                    try {
                        Files.delete(this.binary);
                    }
                    catch (IOException e) {
                        LOG.warning(String.format("%s deleting temporal file: %s", e.getClass().getSimpleName(), e.getMessage()));
                    }
                }
            }));
        } else {
            LOG.fine(String.format("Selenium Manager set by env 'SE_MANAGER_PATH': %s", this.managerPath));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SeleniumManager getInstance() {
        if (manager != null) return manager;
        Class<SeleniumManager> clazz = SeleniumManager.class;
        synchronized (SeleniumManager.class) {
            if (manager != null) return manager;
            manager = new SeleniumManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return manager;
        }
    }

    private static SeleniumManagerOutput.Result runCommand(Path binary, List<String> arguments) {
        String output;
        int code;
        LOG.fine(String.format("Executing Process: %s", arguments));
        try {
            ExternalProcess.Builder processBuilder = ExternalProcess.builder().bufferSize(-1);
            Properties properties = System.getProperties();
            for (String name : properties.stringPropertyNames()) {
                String value;
                if (!name.startsWith(SE_ENV_PREFIX) || (value = properties.getProperty(name, "")).isEmpty()) continue;
                processBuilder.environment(name, value);
            }
            ExternalProcess process = processBuilder.command(binary.toAbsolutePath().toString(), arguments).start();
            if (!process.waitFor(Duration.ofHours(1L))) {
                LOG.warning("Selenium Manager did not exit, shutting it down");
                process.shutdown();
            }
            code = process.exitValue();
            output = process.getOutput(StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new WebDriverException("Failed to run command: " + String.valueOf(arguments), (Throwable)e);
        }
        SeleniumManagerOutput jsonOutput = null;
        JsonException failedToParse = null;
        String dump = output;
        if (!output.isEmpty()) {
            try {
                jsonOutput = (SeleniumManagerOutput)new Json().toType(output, SeleniumManagerOutput.class);
                jsonOutput.getLogs().forEach(logged -> {
                    Level currentLevel = logged.getLevel() == Level.INFO ? Level.FINE : logged.getLevel();
                    LOG.log(currentLevel, logged.getMessage());
                });
                dump = jsonOutput.getResult().getMessage();
            }
            catch (JsonException e) {
                failedToParse = e;
            }
        }
        if (code != 0) {
            throw new WebDriverException("Command failed with code: " + code + ", executed: " + String.valueOf(arguments) + "\n" + dump, (Throwable)failedToParse);
        }
        if (failedToParse != null || jsonOutput == null) {
            throw new WebDriverException("Failed to parse json output, executed: " + String.valueOf(arguments) + "\n" + dump, (Throwable)failedToParse);
        }
        return jsonOutput.getResult();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized Path getBinary() {
        block18: {
            if (this.binary == null) {
                try {
                    Platform current = Platform.getCurrent();
                    String folder = "";
                    String extension = "";
                    if (current.is(Platform.WINDOWS)) {
                        extension = EXE;
                        folder = "windows";
                    } else if (current.is(Platform.MAC)) {
                        folder = "macos";
                    } else if (current.is(Platform.LINUX)) {
                        if (System.getProperty("os.arch").contains("arm")) {
                            throw new WebDriverException("Linux ARM is not supported by Selenium Manager");
                        }
                        folder = "linux";
                    } else {
                        if (!current.is(Platform.UNIX)) {
                            throw new WebDriverException("Unsupported platform: " + String.valueOf(current));
                        }
                        LOG.warning(String.format("Selenium Manager binary may not be compatible with %s; verify settings", current));
                        folder = "linux";
                    }
                    this.binary = this.getBinaryInCache(SELENIUM_MANAGER + extension);
                    if (Files.exists(this.binary, new LinkOption[0])) break block18;
                    String binaryPathInJar = String.format("%s/%s%s", folder, SELENIUM_MANAGER, extension);
                    try (InputStream inputStream = Objects.requireNonNull(this.getClass().getResourceAsStream(binaryPathInJar));){
                        Files.createDirectories(this.binary.getParent(), new FileAttribute[0]);
                        this.saveToFileSafely(inputStream, this.binary);
                        break block18;
                    }
                }
                catch (Exception e) {
                    throw new WebDriverException("Unable to obtain Selenium Manager Binary", (Throwable)e);
                }
            }
            if (!Files.exists(this.binary, new LinkOption[0])) {
                throw new WebDriverException(String.format("Unable to obtain Selenium Manager Binary at: %s", this.binary));
            }
        }
        this.binary.toFile().setExecutable(true);
        LOG.fine(String.format("Selenium Manager binary found at: %s", this.binary));
        return this.binary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveToFileSafely(InputStream inputStream, Path target) throws IOException {
        Path temporaryFile = target.resolveSibling(String.valueOf(target.getFileName()) + "." + String.valueOf(UUID.randomUUID()) + ".tmp");
        Files.copy(inputStream, temporaryFile, new CopyOption[0]);
        try {
            if (!Files.exists(target, new LinkOption[0])) {
                Files.move(temporaryFile, target, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        finally {
            Files.deleteIfExists(temporaryFile);
        }
    }

    public SeleniumManagerOutput.Result getBinaryPaths(List<String> arguments) {
        ArrayList<String> args = new ArrayList<String>(arguments.size() + 5);
        args.addAll(arguments);
        args.add("--language-binding");
        args.add("java");
        args.add("--output");
        args.add("json");
        if (this.getLogLevel().intValue() <= Level.FINE.intValue()) {
            args.add("--debug");
        }
        return SeleniumManager.runCommand(this.getBinary(), args);
    }

    private Level getLogLevel() {
        Level level = LOG.getLevel();
        if (level == null && LOG.getParent() != null) {
            level = LOG.getParent().getLevel();
        }
        if (level == null) {
            return Level.INFO;
        }
        return level;
    }

    private Path getBinaryInCache(String binaryName) throws IOException {
        Path cacheParent;
        String cachePath = System.getProperty(CACHE_PATH_ENV, "");
        if (cachePath.isEmpty()) {
            cachePath = System.getenv(CACHE_PATH_ENV);
        }
        if (cachePath == null) {
            cachePath = DEFAULT_CACHE_PATH;
        }
        if (!Files.isWritable(cacheParent = Paths.get(cachePath = cachePath.replace(HOME, System.getProperty("user.home")), new String[0]))) {
            cacheParent = Files.createTempDirectory(SELENIUM_MANAGER, new FileAttribute[0]);
            this.binaryInTemporalFolder = true;
        }
        return Paths.get(cacheParent.toString(), String.format(BINARY_PATH_FORMAT, this.seleniumManagerVersion, binaryName));
    }
}

